/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.concurrent.CountingFutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAbstractBinAsyncEntityConsumer {
    TestAbstractBinAsyncEntityConsumer() {
    }

    @Test
    void testConsumeData() throws Exception {
        ByteArrayAsyncEntityConsumer consumer = new ByteArrayAsyncEntityConsumer();
        CountingFutureCallback countingCallback = new CountingFutureCallback();
        consumer.streamStart((EntityDetails)new BasicEntityDetails(-1L, ContentType.APPLICATION_OCTET_STREAM), countingCallback);
        consumer.consume(ByteBuffer.wrap(new byte[]{49, 50, 51}));
        consumer.consume(ByteBuffer.wrap(new byte[]{52, 53}));
        consumer.consume(ByteBuffer.wrap(new byte[0]));
        Assertions.assertNull((Object)consumer.getContent());
        consumer.streamEnd(null);
        Assertions.assertArrayEquals((byte[])new byte[]{49, 50, 51, 52, 53}, (byte[])((byte[])consumer.getContent()));
        Assertions.assertEquals((long)1L, (long)countingCallback.getCount());
    }

    private static class ByteArrayAsyncEntityConsumer
    extends AbstractBinAsyncEntityConsumer<byte[]> {
        private final ByteArrayBuffer buffer = new ByteArrayBuffer(1024);

        protected void streamStart(ContentType contentType) throws HttpException, IOException {
        }

        protected int capacityIncrement() {
            return Integer.MAX_VALUE;
        }

        protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
            this.buffer.append(src);
        }

        protected byte[] generateContent() throws IOException {
            return this.buffer.toByteArray();
        }

        public void releaseResources() {
        }
    }
}

