/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index;

import java.util.List;
import org.apache.ignite.internal.binarytuple.BinaryTupleCommon;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.sql.ColumnType;

public class InlineUtils {
    public static final int MAX_BINARY_TUPLE_INLINE_SIZE = 2048;
    static final int MAX_VARLEN_INLINE_SIZE = 64;
    static final int MAX_BINARY_TUPLE_OFFSET_TABLE_ENTRY_SIZE = 2;
    static final int MIN_INNER_PAGE_ITEM_COUNT = 2;
    static final int BIG_NUMBER_INLINE_SIZE = 4;

    static int inlineSize(NativeType nativeType) {
        if (nativeType.fixedLength()) {
            return nativeType.sizeInBytes();
        }
        ColumnType spec = nativeType.spec();
        switch (spec) {
            case STRING: 
            case BYTE_ARRAY: {
                return Math.min(64, ((VarlenNativeType)nativeType).length());
            }
            case DECIMAL: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(spec));
    }

    static int binaryTupleInlineSize(StorageIndexDescriptor indexDescriptor) {
        List columns = indexDescriptor.columns();
        assert (!columns.isEmpty());
        int columnsInlineSize = columns.stream().map(StorageIndexDescriptor.StorageColumnDescriptor::type).mapToInt(InlineUtils::inlineSize).sum();
        int inlineSize = 1 + columns.size() * Math.min(2, BinaryTupleCommon.valueSizeToEntrySize((long)columnsInlineSize)) + columnsInlineSize;
        return Math.min(inlineSize, 2048);
    }

    public static int binaryTupleInlineSize(int pageSize, int itemHeaderSize, StorageIndexDescriptor indexDescriptor) {
        int maxInnerNodeItemSize = (InlineUtils.innerNodePayloadSize(pageSize) - 6) / 2 - 6;
        int binaryTupleInlineSize = Math.min(maxInnerNodeItemSize - itemHeaderSize, InlineUtils.binaryTupleInlineSize(indexDescriptor));
        if (binaryTupleInlineSize >= 2048) {
            return 2048;
        }
        if (indexDescriptor.columns().stream().anyMatch(c -> !c.type().fixedLength())) {
            int itemSize = binaryTupleInlineSize + itemHeaderSize;
            int innerNodeItemSize = InlineUtils.optimizeItemSize(InlineUtils.innerNodePayloadSize(pageSize) - 6, itemSize + 6) - 6;
            int leafNodeItemSize = InlineUtils.optimizeItemSize(InlineUtils.leafNodePayloadSize(pageSize), itemSize);
            int optimizedItemSize = Math.min(innerNodeItemSize, leafNodeItemSize);
            assert (InlineUtils.leafNodePayloadSize(pageSize) / itemSize == InlineUtils.leafNodePayloadSize(pageSize) / optimizedItemSize);
            binaryTupleInlineSize = optimizedItemSize - itemHeaderSize;
        }
        return Math.min(binaryTupleInlineSize, 2048);
    }

    static int innerNodePayloadSize(int pageSize) {
        return pageSize - 56;
    }

    static int leafNodePayloadSize(int pageSize) {
        return pageSize - 56;
    }

    static int optimizeItemSize(int nodePayloadSize, int itemSize) {
        int remainingNodePayloadSize = nodePayloadSize % itemSize;
        int nodeItemCount = nodePayloadSize / itemSize;
        int additionalNodeItemBytes = remainingNodePayloadSize / nodeItemCount;
        return itemSize + additionalNodeItemBytes;
    }

    public static boolean canFullyInline(int indexColumnsSize, int inlineSize) {
        return indexColumnsSize <= inlineSize + 6;
    }
}

