/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.cli.core.repl.PeriodicSessionTask;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

@Singleton
public class PeriodicSessionTaskExecutor
implements ConnectionEventListener {
    private static final IgniteLogger LOG = CliLoggers.forClass(PeriodicSessionTaskExecutor.class);
    @Nullable
    private ScheduledExecutorService executor;
    private final List<? extends PeriodicSessionTask> tasks;

    public PeriodicSessionTaskExecutor(List<? extends PeriodicSessionTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public synchronized void onConnect(SessionInfo sessionInfo) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("SessionTaskExecutor", LOG));
            this.executor.scheduleWithFixedDelay(() -> this.runTasks(sessionInfo), 0L, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public synchronized void onDisconnect() {
        if (this.executor != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)3L, (TimeUnit)TimeUnit.SECONDS);
            this.tasks.forEach(PeriodicSessionTask::onDisconnect);
            this.executor = null;
        }
    }

    private void runTasks(SessionInfo sessionInfo) {
        this.tasks.forEach(periodicSessionTask -> periodicSessionTask.update(sessionInfo));
    }
}

