/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateMetaMessage;
import org.apache.ignite.internal.tx.message.TxStateMetaMessageBuilder;

class TxStateMetaMessageDeserializer
implements MessageDeserializer<TxStateMetaMessage> {
    private final TxStateMetaMessageBuilder msg;

    TxStateMetaMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateMetaMessage();
    }

    public Class<TxStateMetaMessage> klass() {
        return TxStateMetaMessage.class;
    }

    public TxStateMetaMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<Long> tmp = reader.readBoxedLong("cleanupCompletionTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cleanupCompletionTimestamp((Long)tmp);
                reader.incrementState();
            }
            case 1: {
                Comparable<Long> tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<Long> tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 3: {
                Comparable<Long> tmp = reader.readBoxedLong("initialVacuumObservationTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initialVacuumObservationTimestamp((Long)tmp);
                reader.incrementState();
            }
            case 4: {
                Comparable<Long> tmp = reader.readBoxedBoolean("isFinishedDueToTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.isFinishedDueToTimeout((Boolean)tmp);
                reader.incrementState();
            }
            case 5: {
                Comparable<Long> tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txCoordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 6: {
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                this.msg.txState(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateMetaMessage.class);
    }
}

