/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAddColumnCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.NewColumnsEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.util.CollectionUtils;

public class AlterTableAddColumnCommand
extends AbstractTableCommand {
    private final List<ColumnParams> columns;

    public static AlterTableAddColumnCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableAddColumnCommand(String tableName, String schemaName, boolean ifTableExists, List<ColumnParams> columns) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
        this.columns = CollectionUtils.copyOrNull(columns);
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        ArrayList<CatalogTableColumnDescriptor> columnDescriptors = new ArrayList<CatalogTableColumnDescriptor>();
        for (ColumnParams column : this.columns) {
            if (table.column(column.name()) != null) {
                throw new CatalogValidationException("Column with name '{}' already exists.", column.name());
            }
            columnDescriptors.add(CatalogUtils.fromParams(column));
        }
        return List.of(new NewColumnsEntry(table.id(), columnDescriptors));
    }

    private void validate() {
        if (CollectionUtils.nullOrEmpty(this.columns)) {
            throw new CatalogValidationException("Columns not specified.");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnParams column : this.columns) {
            if (!columnNames.add(column.name())) {
                throw new CatalogValidationException("Column with name '{}' specified more than once.", column.name());
            }
            CatalogUtils.ensureTypeCanBeStored(column.name(), column.type());
            CatalogUtils.ensureNonFunctionalDefault(column.name(), column.defaultValueDefinition());
        }
    }

    private static class Builder
    implements AlterTableAddColumnCommandBuilder {
        private List<ColumnParams> columns;
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableAddColumnCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableAddColumnCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableAddColumnCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public AlterTableAddColumnCommandBuilder columns(List<ColumnParams> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableAddColumnCommand(this.tableName, this.schemaName, this.ifTableExists, this.columns);
        }
    }
}

