/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.jetbrains.annotations.Nullable;

public abstract class TablePrimaryKey {
    @Nullable
    private final String name;
    private final List<String> columns;

    TablePrimaryKey(@Nullable String name, List<String> columns) {
        this.name = name;
        this.columns = columns != null ? List.copyOf(columns) : List.of();
    }

    public List<String> columns() {
        return this.columns;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    void validate(List<ColumnParams> allColumns) {
        if (this.name != null) {
            CatalogParamsValidationUtils.validateIdentifier(this.name, "Name of the primary key constraint");
        }
        HashSet<String> allColumnNames = new HashSet<String>(allColumns.size());
        for (ColumnParams column : allColumns) {
            allColumnNames.add(column.name());
            boolean partOfPk = this.columns.contains(column.name());
            if (!partOfPk || !column.nullable()) continue;
            throw new CatalogValidationException("Primary key cannot contain nullable column [col={}].", column.name());
        }
        List columnsNotInTable = this.columns.stream().filter(Predicate.not(allColumnNames::contains)).collect(Collectors.toList());
        if (!columnsNotInTable.isEmpty()) {
            throw new CatalogValidationException("Primary key constraint contains undefined columns: [cols={}].", columnsNotInTable);
        }
        HashSet<String> columnSet = new HashSet<String>();
        for (String name : this.columns) {
            if (columnSet.add(name)) continue;
            throw new CatalogValidationException("PK column '{}' specified more that once.", name);
        }
    }

    public static abstract class TablePrimaryKeyBuilder<T extends TablePrimaryKeyBuilder<T>> {
        public abstract T columns(List<String> var1);

        public abstract T name(@Nullable String var1);

        public abstract TablePrimaryKey build();
    }
}

