/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.completer.unit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.ignite3.internal.cli.commands.Options;
import org.apache.ignite3.internal.cli.commands.cluster.unit.NodesAlias;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.CompleterFilter;

public class UnitNodesCompleterFilter
implements CompleterFilter {
    private final Set<String> options = Options.UNIT_NODES.names();

    @Override
    public String[] filter(String[] words, String[] candidates) {
        int nodesSpecifiedTimes = 0;
        boolean prevWordIsNodes = false;
        HashSet specifiedNodes = new HashSet();
        for (String word : words) {
            if (prevWordIsNodes) {
                Arrays.stream(word.split(",")).map(String::trim).filter(it -> !it.isBlank()).forEach(specifiedNodes::add);
                prevWordIsNodes = false;
                continue;
            }
            if (!this.options.contains(word)) continue;
            ++nodesSpecifiedTimes;
            prevWordIsNodes = true;
        }
        Stream<String> candidatesWithoutAlreadySpecifiedNodes = Arrays.stream(candidates).filter(it -> !specifiedNodes.contains(it));
        if (nodesSpecifiedTimes <= 1) {
            return (String[])candidatesWithoutAlreadySpecifiedNodes.toArray(String[]::new);
        }
        return (String[])candidatesWithoutAlreadySpecifiedNodes.filter(it -> {
            NodesAlias a = NodesAlias.parse(it);
            return a == null;
        }).toArray(String[]::new);
    }
}

