/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.tx.TransactionMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMeta;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxStateMetaFinishingMessage;
import org.jetbrains.annotations.Nullable;

public class TxStateMetaFinishing
extends TxStateMeta {
    private static final long serialVersionUID = 9122953981654023665L;
    private final CompletableFuture<TransactionMeta> txFinishFuture = new CompletableFuture();

    public TxStateMetaFinishing(@Nullable UUID txCoordinatorId, @Nullable ReplicationGroupId commitPartitionId, @Nullable Boolean isFinishingDueToTimeout) {
        super(TxState.FINISHING, txCoordinatorId, commitPartitionId, null, null, isFinishingDueToTimeout);
    }

    public CompletableFuture<TransactionMeta> txFinishFuture() {
        return this.txFinishFuture;
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        throw new UnsupportedOperationException("Can't get commit timestamp from FINISHING transaction state meta.");
    }

    @Override
    public TxStateMetaFinishingMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        ReplicationGroupId commitPartitionId = this.commitPartitionId();
        return txMessagesFactory.txStateMetaFinishingMessage().txState(this.txState()).txCoordinatorId(this.txCoordinatorId()).commitPartitionId(commitPartitionId == null ? null : ReplicaMessageUtils.toReplicationGroupIdMessage(replicaMessagesFactory, commitPartitionId)).commitTimestamp(this.commitTimestamp()).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp()).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxStateMetaFinishing that = (TxStateMetaFinishing)o;
        return this.txFinishFuture.equals(that.txFinishFuture);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.txFinishFuture.hashCode();
        return result;
    }
}

