/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ClusterOptions {
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Duration> INITIAL_REGISTRATION_TIMEOUT = ConfigOptions.key("cluster.registration.initial-timeout").durationType().defaultValue(Duration.ofMillis(100L)).withDescription("Initial registration timeout between cluster components.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Duration> MAX_REGISTRATION_TIMEOUT = ConfigOptions.key("cluster.registration.max-timeout").durationType().defaultValue(Duration.ofMillis(30000L)).withDescription("Maximum registration timeout between cluster components.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Duration> ERROR_REGISTRATION_DELAY = ConfigOptions.key("cluster.registration.error-delay").durationType().defaultValue(Duration.ofMillis(10000L)).withDescription("The pause made after an registration attempt caused an exception (other than timeout).");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Duration> REFUSED_REGISTRATION_DELAY = ConfigOptions.key("cluster.registration.refused-registration-delay").durationType().defaultValue(Duration.ofMillis(30000L)).withDescription("The pause made after the registration attempt was refused.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Duration> CLUSTER_SERVICES_SHUTDOWN_TIMEOUT = ConfigOptions.key("cluster.services.shutdown-timeout").durationType().defaultValue(Duration.ofMillis(30000L)).withDescription("The shutdown timeout for cluster services like executors.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Integer> CLUSTER_IO_EXECUTOR_POOL_SIZE = ConfigOptions.key("cluster.io-pool.size").intType().noDefaultValue().withDescription("The size of the IO executor pool used by the cluster to execute blocking IO operations (Master as well as TaskManager processes). By default it will use 4 * the number of CPU cores (hardware contexts) that the cluster process has access to. Increasing the pool size allows to run more IO operations concurrently.");
    @Deprecated
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Boolean> EVENLY_SPREAD_OUT_SLOTS_STRATEGY = ConfigOptions.key("cluster.evenly-spread-out-slots").booleanType().defaultValue(false).withDescription(Description.builder().text("Enable the slot spread out allocation strategy. This strategy tries to spread out the slots evenly across all available %s.", TextElement.code("TaskExecutors")).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<Boolean> HALT_ON_FATAL_ERROR = ConfigOptions.key("cluster.processes.halt-on-fatal-error").booleanType().defaultValue(false).withDescription(Description.builder().text("Whether processes should halt on fatal errors instead of performing a graceful shutdown. In some environments (e.g. Java 8 with the G1 garbage collector), a regular graceful shutdown can lead to a JVM deadlock. See %s for details.", LinkElement.link("https://issues.apache.org/jira/browse/FLINK-16510", "FLINK-16510")).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<UserSystemExitMode> INTERCEPT_USER_SYSTEM_EXIT = ConfigOptions.key("cluster.intercept-user-system-exit").enumType(UserSystemExitMode.class).defaultValue(UserSystemExitMode.DISABLED).withDescription(Description.builder().text("Flag to check user code exiting system by terminating JVM (e.g., System.exit()). ").text("Note that this configuration option can interfere with %s: In intercepted user-code, a call to System.exit() will not cause the JVM to halt, when %s is configured.", TextElement.code(HALT_ON_FATAL_ERROR.key()), TextElement.code(UserSystemExitMode.THROW.name())).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<Integer> THREAD_DUMP_STACKTRACE_MAX_DEPTH = ConfigOptions.key("cluster.thread-dump.stacktrace-max-depth").intType().defaultValue(50).withDescription("The maximum stacktrace depth of TaskManager and JobManager's thread dump web-frontend displayed.");
    @Deprecated
    public static final ConfigOption<Boolean> FINE_GRAINED_SHUFFLE_MODE_ALL_BLOCKING = ConfigOptions.key("fine-grained.shuffle-mode.all-blocking").booleanType().defaultValue(false).withDescription("Whether to convert all PIPELINE edges to BLOCKING when apply fine-grained resource management in batch jobs.");
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<UncaughtExceptionHandleMode> UNCAUGHT_EXCEPTION_HANDLING = ConfigOptions.key("cluster.uncaught-exception-handling").enumType(UncaughtExceptionHandleMode.class).defaultValue(UncaughtExceptionHandleMode.LOG).withDescription(String.format("Defines whether cluster will handle any uncaught exceptions by just logging them (%s mode), or by failing job (%s mode)", UncaughtExceptionHandleMode.LOG.name(), UncaughtExceptionHandleMode.FAIL.name()));
    @Documentation.OverrideDefault(value="io.tmp.dirs")
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<String> PROCESS_WORKING_DIR_BASE = ConfigOptions.key("process.working-dir").stringType().noDefaultValue().withDescription(Description.builder().text("Local working directory for Flink processes. The working directory can be used to store information that can be used upon process recovery. If not configured, then it will default to a randomly picked temporary directory defined via %s.", TextElement.code(CoreOptions.TMP_DIRS.key())).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<String> JOB_MANAGER_PROCESS_WORKING_DIR_BASE = ConfigOptions.key("process.jobmanager.working-dir").stringType().noDefaultValue().withFallbackKeys(PROCESS_WORKING_DIR_BASE.key()).withDescription(Description.builder().text("Working directory for Flink JobManager processes. The working directory can be used to store information that can be used upon process recovery. If not configured, then it will default to %s.", TextElement.code(PROCESS_WORKING_DIR_BASE.key())).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<String> TASK_MANAGER_PROCESS_WORKING_DIR_BASE = ConfigOptions.key("process.taskmanager.working-dir").stringType().noDefaultValue().withFallbackKeys(PROCESS_WORKING_DIR_BASE.key()).withDescription(Description.builder().text("Working directory for Flink TaskManager processes. The working directory can be used to store information that can be used upon process recovery. If not configured, then it will default to %s.", TextElement.code(PROCESS_WORKING_DIR_BASE.key())).build());

    public static JobManagerOptions.SchedulerType getSchedulerType(Configuration configuration) {
        if (ClusterOptions.isAdaptiveSchedulerEnabled(configuration) || ClusterOptions.isReactiveModeEnabled(configuration)) {
            return JobManagerOptions.SchedulerType.Adaptive;
        }
        return configuration.get(JobManagerOptions.SCHEDULER);
    }

    public static boolean isReactiveModeEnabled(Configuration configuration) {
        return configuration.get(JobManagerOptions.SCHEDULER_MODE) == SchedulerExecutionMode.REACTIVE;
    }

    public static boolean isAdaptiveSchedulerEnabled(Configuration configuration) {
        if (configuration.contains(JobManagerOptions.SCHEDULER)) {
            return configuration.get(JobManagerOptions.SCHEDULER) == JobManagerOptions.SchedulerType.Adaptive;
        }
        return System.getProperties().containsKey("flink.tests.enable-adaptive-scheduler");
    }

    public static enum UncaughtExceptionHandleMode {
        LOG,
        FAIL;

    }

    public static enum UserSystemExitMode implements DescribedEnum
    {
        DISABLED(TextElement.text("Flink is not monitoring or intercepting calls to System.exit()")),
        LOG(TextElement.text("Log exit attempt with stack trace but still allowing exit to be performed")),
        THROW(TextElement.text("Throw exception when exit is attempted disallowing JVM termination"));

        private final InlineElement description;

        private UserSystemExitMode(InlineElement description) {
            this.description = description;
        }

        @Override
        public InlineElement getDescription() {
            return this.description;
        }
    }
}

