/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.Quotas;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.StatsTrack;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.ZooKeeper;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.cli.CliCommand;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.cli.CliException;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.cli.CliParseException;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.cli.CliWrapperException;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.amoro.shade.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ListQuotaCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public ListQuotaCommand() {
        super("listquota", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        DefaultParser parser = new DefaultParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        String absolutePath = Quotas.limitPath(path);
        try {
            this.err.println("absolute path is " + absolutePath);
            List<StatsTrack> statsTracks = ListQuotaCommand.listQuota(this.zk, path);
            for (int i = 0; i < statsTracks.size(); ++i) {
                StatsTrack st = statsTracks.get(i);
                if (i == 0) {
                    this.out.println("Output quota for " + path + " " + st.toString());
                    continue;
                }
                this.out.println("Output stat for " + path + " " + st.toString());
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException.NoNodeException ne) {
            this.err.println("quota for " + path + " does not exist.");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    public static List<StatsTrack> listQuota(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        ArrayList<StatsTrack> statsTracks = new ArrayList<StatsTrack>();
        Stat stat = new Stat();
        byte[] data = zk.getData(Quotas.limitPath(path), false, stat);
        StatsTrack st = new StatsTrack(data);
        statsTracks.add(st);
        data = zk.getData(Quotas.statPath(path), false, stat);
        st = new StatsTrack(data);
        statsTracks.add(st);
        return statsTracks;
    }
}

