/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.operators.async.queue.StreamRecordQueueEntry;
import org.apache.flink.streaming.api.operators.async.queue.WatermarkQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class OrderedStreamElementQueue<OUT>
implements StreamElementQueue<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedStreamElementQueue.class);
    private final int capacity;
    private final Queue<StreamElementQueueEntry<OUT>> queue;

    public OrderedStreamElementQueue(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The capacity must be larger than 0.");
        this.capacity = capacity;
        this.queue = new ArrayDeque<StreamElementQueueEntry<OUT>>(capacity);
    }

    @Override
    public boolean hasCompletedElements() {
        return !this.queue.isEmpty() && this.queue.peek().isDone();
    }

    @Override
    public void emitCompletedElement(TimestampedCollector<OUT> output) {
        if (this.hasCompletedElements()) {
            StreamElementQueueEntry<OUT> head = this.queue.poll();
            head.emitResult(output);
        }
    }

    @Override
    public List<StreamElement> values() {
        ArrayList<StreamElement> list = new ArrayList<StreamElement>(this.queue.size());
        for (StreamElementQueueEntry streamElementQueueEntry : this.queue) {
            list.add(streamElementQueueEntry.getInputElement());
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Optional<ResultFuture<OUT>> tryPut(StreamElement streamElement) {
        if (this.queue.size() < this.capacity) {
            StreamElementQueueEntry<OUT> queueEntry = this.createEntry(streamElement);
            this.queue.add(queueEntry);
            LOG.debug("Put element into ordered stream element queue. New filling degree ({}/{}).", (Object)this.queue.size(), (Object)this.capacity);
            return Optional.of(queueEntry);
        }
        LOG.debug("Failed to put element into ordered stream element queue because it was full ({}/{}).", (Object)this.queue.size(), (Object)this.capacity);
        return Optional.empty();
    }

    private StreamElementQueueEntry<OUT> createEntry(StreamElement streamElement) {
        if (streamElement.isRecord()) {
            return new StreamRecordQueueEntry((StreamRecord)streamElement);
        }
        if (streamElement.isWatermark()) {
            return new WatermarkQueueEntry((Watermark)streamElement);
        }
        throw new UnsupportedOperationException("Cannot enqueue " + streamElement);
    }
}

