/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.rest.handler.router.MethodlessRouter;
import org.apache.flink.runtime.rest.handler.router.PathPattern;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;

public class Router<T> {
    private final Map<HttpMethod, MethodlessRouter<T>> routers = new HashMap<HttpMethod, MethodlessRouter<T>>();
    private final MethodlessRouter<T> anyMethodRouter = new MethodlessRouter();
    private T notFound;

    private static <T> void aggregateRoutes(String method, Map<PathPattern, T> routes, List<String> accMethods, List<String> accPatterns, List<String> accTargets) {
        for (Map.Entry<PathPattern, T> entry : routes.entrySet()) {
            accMethods.add(method);
            accPatterns.add("/" + entry.getKey().pattern());
            accTargets.add(Router.targetToString(entry.getValue()));
        }
    }

    private static int maxLength(List<String> coll) {
        int max = 0;
        for (String e : coll) {
            int length = e.length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    private static String targetToString(Object target) {
        if (target instanceof Class) {
            return ((Class)target).getName();
        }
        return target.toString();
    }

    public T notFound() {
        return this.notFound;
    }

    public int size() {
        int ret = this.anyMethodRouter.size();
        for (MethodlessRouter<T> router : this.routers.values()) {
            ret += router.size();
        }
        return ret;
    }

    public Router<T> addRoute(HttpMethod method, String pathPattern, T target) {
        this.getMethodlessRouter(method).addRoute(pathPattern, target);
        return this;
    }

    public Router<T> notFound(T target) {
        this.notFound = target;
        return this;
    }

    private MethodlessRouter<T> getMethodlessRouter(HttpMethod method) {
        if (method == null) {
            return this.anyMethodRouter;
        }
        MethodlessRouter<T> router = this.routers.get(method);
        if (router == null) {
            router = new MethodlessRouter();
            this.routers.put(method, router);
        }
        return router;
    }

    public void removePathPattern(String pathPattern) {
        for (MethodlessRouter<T> router : this.routers.values()) {
            router.removePathPattern(pathPattern);
        }
        this.anyMethodRouter.removePathPattern(pathPattern);
    }

    public RouteResult<T> route(HttpMethod method, String path) {
        return this.route(method, path, Collections.emptyMap());
    }

    public RouteResult<T> route(HttpMethod method, String path, Map<String, List<String>> queryParameters) {
        String[] tokens;
        RouteResult<T> ret;
        MethodlessRouter<T> router = this.routers.get(method);
        if (router == null) {
            router = this.anyMethodRouter;
        }
        if ((ret = router.route(path, path, queryParameters, tokens = Router.decodePathTokens(path))) != null) {
            return new RouteResult<T>(path, path, ret.pathParams(), queryParameters, ret.target());
        }
        if (router != this.anyMethodRouter && (ret = this.anyMethodRouter.route(path, path, queryParameters, tokens)) != null) {
            return new RouteResult<T>(path, path, ret.pathParams(), queryParameters, ret.target());
        }
        if (this.notFound != null) {
            return new RouteResult<T>(path, path, Collections.emptyMap(), queryParameters, this.notFound);
        }
        return null;
    }

    static String[] decodePathTokens(String uri) {
        int qPos = uri.indexOf("?");
        String encodedPath = qPos >= 0 ? uri.substring(0, qPos) : uri;
        String[] encodedTokens = PathPattern.removeSlashesAtBothEnds(encodedPath).split("/");
        String[] decodedTokens = new String[encodedTokens.length];
        for (int i = 0; i < encodedTokens.length; ++i) {
            String encodedToken = encodedTokens[i];
            decodedTokens[i] = QueryStringDecoder.decodeComponent((String)encodedToken);
        }
        return decodedTokens;
    }

    public Set<HttpMethod> allowedMethods(String uri) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        String[] tokens = PathPattern.removeSlashesAtBothEnds(decoder.path()).split("/");
        if (this.anyMethodRouter.anyMatched(tokens)) {
            return this.allAllowedMethods();
        }
        HashSet<HttpMethod> ret = new HashSet<HttpMethod>(this.routers.size());
        for (Map.Entry<HttpMethod, MethodlessRouter<T>> entry : this.routers.entrySet()) {
            MethodlessRouter<T> router = entry.getValue();
            if (!router.anyMatched(tokens)) continue;
            HttpMethod method = entry.getKey();
            ret.add(method);
        }
        return ret;
    }

    public Set<HttpMethod> allAllowedMethods() {
        if (this.anyMethodRouter.size() > 0) {
            HashSet<HttpMethod> ret = new HashSet<HttpMethod>(9);
            ret.add(HttpMethod.CONNECT);
            ret.add(HttpMethod.DELETE);
            ret.add(HttpMethod.GET);
            ret.add(HttpMethod.HEAD);
            ret.add(HttpMethod.OPTIONS);
            ret.add(HttpMethod.PATCH);
            ret.add(HttpMethod.POST);
            ret.add(HttpMethod.PUT);
            ret.add(HttpMethod.TRACE);
            return ret;
        }
        return new HashSet<HttpMethod>(this.routers.keySet());
    }

    public String toString() {
        int numRoutes = this.size();
        ArrayList<String> methods = new ArrayList<String>(numRoutes);
        ArrayList<String> patterns = new ArrayList<String>(numRoutes);
        ArrayList<String> targets = new ArrayList<String>(numRoutes);
        for (Map.Entry<HttpMethod, MethodlessRouter<T>> e : this.routers.entrySet()) {
            HttpMethod method = e.getKey();
            MethodlessRouter<T> router = e.getValue();
            Router.aggregateRoutes(method.toString(), router.routes(), methods, patterns, targets);
        }
        Router.aggregateRoutes("*", this.anyMethodRouter.routes(), methods, patterns, targets);
        if (this.notFound != null) {
            methods.add("*");
            patterns.add("*");
            targets.add(Router.targetToString(this.notFound));
        }
        int maxLengthMethod = Router.maxLength(methods);
        int maxLengthPattern = Router.maxLength(patterns);
        String format = "%-" + maxLengthMethod + "s  %-" + maxLengthPattern + "s  %s\n";
        int initialCapacity = (maxLengthMethod + 1 + maxLengthPattern + 1 + 20) * methods.size();
        StringBuilder b = new StringBuilder(initialCapacity);
        for (int i = 0; i < methods.size(); ++i) {
            String method = (String)methods.get(i);
            String pattern = (String)patterns.get(i);
            String target = (String)targets.get(i);
            b.append(String.format(format, method, pattern, target));
        }
        return b.toString();
    }

    public Router<T> addConnect(String path, T target) {
        return this.addRoute(HttpMethod.CONNECT, path, target);
    }

    public Router<T> addDelete(String path, T target) {
        return this.addRoute(HttpMethod.DELETE, path, target);
    }

    public Router<T> addGet(String path, T target) {
        return this.addRoute(HttpMethod.GET, path, target);
    }

    public Router<T> addHead(String path, T target) {
        return this.addRoute(HttpMethod.HEAD, path, target);
    }

    public Router<T> addOptions(String path, T target) {
        return this.addRoute(HttpMethod.OPTIONS, path, target);
    }

    public Router<T> addPatch(String path, T target) {
        return this.addRoute(HttpMethod.PATCH, path, target);
    }

    public Router<T> addPost(String path, T target) {
        return this.addRoute(HttpMethod.POST, path, target);
    }

    public Router<T> addPut(String path, T target) {
        return this.addRoute(HttpMethod.PUT, path, target);
    }

    public Router<T> addTrace(String path, T target) {
        return this.addRoute(HttpMethod.TRACE, path, target);
    }

    public Router<T> addAny(String path, T target) {
        return this.addRoute(null, path, target);
    }
}

