/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeleteBehavior {
    LOG("LOG"),
    DELETE_FROM_DATABASE("DELETE_FROM_DATABASE"),
    DEPRECATE_IN_DATABASE("DEPRECATE_IN_DATABASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeleteBehavior> VALUE_MAP;
    private final String value;

    private DeleteBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeleteBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeleteBehavior> knownValues() {
        EnumSet<DeleteBehavior> knownValues = EnumSet.allOf(DeleteBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeleteBehavior.class, DeleteBehavior::toString);
    }
}

