/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse;

public class GetColumnStatisticsTaskRunsIterable
implements SdkIterable<GetColumnStatisticsTaskRunsResponse> {
    private final GlueClient client;
    private final GetColumnStatisticsTaskRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetColumnStatisticsTaskRunsIterable(GlueClient client, GetColumnStatisticsTaskRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetColumnStatisticsTaskRunsResponseFetcher();
    }

    public Iterator<GetColumnStatisticsTaskRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetColumnStatisticsTaskRunsResponseFetcher
    implements SyncPageFetcher<GetColumnStatisticsTaskRunsResponse> {
        private GetColumnStatisticsTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetColumnStatisticsTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetColumnStatisticsTaskRunsResponse nextPage(GetColumnStatisticsTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return GetColumnStatisticsTaskRunsIterable.this.client.getColumnStatisticsTaskRuns(GetColumnStatisticsTaskRunsIterable.this.firstRequest);
            }
            return GetColumnStatisticsTaskRunsIterable.this.client.getColumnStatisticsTaskRuns((GetColumnStatisticsTaskRunsRequest)((Object)GetColumnStatisticsTaskRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

