/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class H2Dialect$
extends JdbcDialect {
    public static H2Dialect$ MODULE$;
    private final Set<String> supportedFunctions;

    static {
        new H2Dialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(9).append("VAR_POP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(10).append("VAR_SAMP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(12).append("STDDEV_POP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string5 = "STDDEV_SAMP";
                if (!(string != null ? !string.equals(string5) : string5 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(distinct).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string6 = "COVAR_POP";
                if (!(string != null ? !string.equals(string6) : string6 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(13).append("COVAR_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string7 = "COVAR_SAMP";
                if (!(string != null ? !string.equals(string7) : string7 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(14).append("COVAR_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (!bl) return None$.MODULE$;
            String string = generalAggregateFunc.name();
            String string8 = "CORR";
            if (string == null) {
                if (string8 != null) {
                    return None$.MODULE$;
                }
            } else if (!string.equals(string8)) return None$.MODULE$;
            if (generalAggregateFunc.isDistinct()) return None$.MODULE$;
            Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
            return new Some((Object)new StringBuilder(8).append("CORR(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
        });
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Some some;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            some = Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            some = new Some((Object)new JdbcType("BOOLEAN", 16));
        } else {
            boolean bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType);
            if (bl) {
                some = new Some((Object)new JdbcType("SMALLINT", 5));
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                some = new Some((Object)new JdbcType(new StringBuilder(10).append("NUMERIC(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 2));
            } else {
                some = JdbcUtils$.MODULE$.getCommonJDBCType(dt);
            }
        }
        return some;
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 42101: {
                    throw new TableAlreadyExistsException(message, (Option)new Some((Object)e));
                }
                case 42102: {
                    throw new NoSuchTableException(message, (Option)new Some((Object)e));
                }
                case 90079: {
                    throw new NoSuchNamespaceException(message, (Option)new Some((Object)e));
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return super.classifyException(message, e);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private H2Dialect$() {
        MODULE$ = this;
        this.supportedFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL"}));
    }
}

