/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.memory.MemoryStore;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005MfA\u0002\u0017.\u0003\u0003yS\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\n5CQ!\u0015\u0001\u0005\u0002ICq!\u0017\u0001C\u0002\u0013E!\f\u0003\u0004_\u0001\u0001\u0006Ia\u0017\u0005\b[\u0002\u0011\r\u0011\"\u0005[\u0011\u0019q\u0007\u0001)A\u00057\"9\u0001\u000f\u0001b\u0001\n#\t\bBB;\u0001A\u0003%!\u000fC\u0004x\u0001\t\u0007I\u0011C9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u001dQ\bA1Q\u0005\u0012mDa\u0001 \u0001!\u0002\u0013i\u0005bB?\u0001\u0005\u0004&\tb\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B'\t\u000b}\u0004a\u0011A>\t\r\u0005\u0005\u0001A\"\u0001|\u0011\u001d\t\u0019\u0001\u0001C\u0003\u0003\u000bAq!a\b\u0001\r\u0003\t\t\u0003C\u0004\u0002D\u00011\t!!\u0012\t\u0011\u00055\u0003A\"\u0001.\u0003\u001fB\u0001\"!\u0017\u0001\t\u0003i\u00131\f\u0005\t\u0003G\u0002A\u0011A\u0017\u0002f!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA9\u0001\u0011\u0015\u00111\u000f\u0005\b\u0003k\u0002AQAA<\u0011\u0019\ti\b\u0001C\u0003w\"1\u0011q\u0010\u0001\u0005\u0006mDa!!!\u0001\t\u000bY\bBBAB\u0001\u0011\u00151\u0010\u0003\u0004\u0002\u0006\u0002!)a\u001f\u0005\u0007\u0003\u000f\u0003AQA>\t\u0011\u0005%\u0005\u0001\"\u0001.\u0003\u0017C\u0011\"a$\u0001\u0005\u0004%)!!%\t\u0011\u0005M\u0005\u0001)A\u0007\u0003{A\u0011\"!&\u0001\u0011\u000b\u0007I\u0011B>\t\u0011\u0005]\u0005A1A\u0005\u0002mDq!!'\u0001A\u0003%Q\n\u0003\u0006\u0002\u001c\u0002\u0011\r\u0011\"\u0002.\u0003;C\u0001\"!,\u0001A\u00035\u0011q\u0014\u0005\u000b\u0003_\u0003\u0001R1A\u0005\n\u0005E&!D'f[>\u0014\u00180T1oC\u001e,'O\u0003\u0002/_\u00051Q.Z7pefT!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\n\u0004\u0001Yb\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g\r\u0005\u0002>\u00016\taH\u0003\u0002@_\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002B}\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002F\r6\tq&\u0003\u0002H_\tI1\u000b]1sW\u000e{gNZ\u0001\t]Vl7i\u001c:fgB\u0011qGS\u0005\u0003\u0017b\u00121!\u00138u\u0003Myg\u000eS3baN#xN]1hK6+Wn\u001c:z!\t9d*\u0003\u0002Pq\t!Aj\u001c8h\u0003Uyg\u000eS3ba\u0016CXmY;uS>tW*Z7pef\fa\u0001P5oSRtD#B*V-^C\u0006C\u0001+\u0001\u001b\u0005i\u0003\"\u0002\"\u0006\u0001\u0004!\u0005\"\u0002%\u0006\u0001\u0004I\u0005\"\u0002'\u0006\u0001\u0004i\u0005\"\u0002)\u0006\u0001\u0004i\u0015aF8o\u0011\u0016\f\u0007o\u0015;pe\u0006<W-T3n_JL\bk\\8m+\u0005Y\u0006C\u0001+]\u0013\tiVFA\tTi>\u0014\u0018mZ3NK6|'/\u001f)p_2\f\u0001d\u001c8IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef\u0004vn\u001c7!Q\u00119\u0001M[6\u0011\u0005\u0005DW\"\u00012\u000b\u0005\r$\u0017AC2p]\u000e,(O]3oi*\u0011QMZ\u0001\u000bC:tw\u000e^1uS>t'\"A4\u0002\u000b)\fg/\u0019=\n\u0005%\u0014'!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u0005a\u0017\u0001\u0002;iSN\f\u0001d\u001c4g\u0011\u0016\f\u0007o\u0015;pe\u0006<W-T3n_JL\bk\\8m\u0003eygM\u001a%fCB\u001cFo\u001c:bO\u0016lU-\\8ssB{w\u000e\u001c\u0011)\t%\u0001'n[\u0001\u001a_:DU-\u00199Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z!>|G.F\u0001s!\t!6/\u0003\u0002u[\t\u0019R\t_3dkRLwN\\'f[>\u0014\u0018\u0010U8pY\u0006QrN\u001c%fCB,\u00050Z2vi&|g.T3n_JL\bk\\8mA!\"1\u0002\u00196l\u0003iygM\u001a%fCB,\u00050Z2vi&|g.T3n_JL\bk\\8m\u0003mygM\u001a%fCB,\u00050Z2vi&|g.T3n_JL\bk\\8mA!\"Q\u0002\u00196l\u0003Ai\u0017\r_(gM\"+\u0017\r]'f[>\u0014\u00180F\u0001N\u0003Ei\u0017\r_(gM\"+\u0017\r]'f[>\u0014\u0018\u0010I\u0001\u0015_\u001a4\u0007*Z1q'R|'/Y4f\u001b\u0016lwN]=\u0002+=4g\rS3baN#xN]1hK6+Wn\u001c:zA\u00051R.\u0019=P]\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u00180A\fnCb|eM\u001a%fCB\u001cFo\u001c:bO\u0016lU-\\8ss\u0006q1/\u001a;NK6|'/_*u_J,G\u0003BA\u0004\u0003\u001b\u00012aNA\u0005\u0013\r\tY\u0001\u000f\u0002\u0005+:LG\u000fC\u0004\u0002\u0010Q\u0001\r!!\u0005\u0002\u000bM$xN]3\u0011\t\u0005M\u00111D\u0007\u0003\u0003+Q1ALA\f\u0015\r\tIbL\u0001\bgR|'/Y4f\u0013\u0011\ti\"!\u0006\u0003\u00175+Wn\u001c:z'R|'/Z\u0001\u0015C\u000e\fX/\u001b:f'R|'/Y4f\u001b\u0016lwN]=\u0015\u0011\u0005\r\u0012\u0011FA\u001b\u0003s\u00012aNA\u0013\u0013\r\t9\u0003\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\tY#\u0006a\u0001\u0003[\tqA\u00197pG.LE\r\u0005\u0003\u00020\u0005ERBAA\f\u0013\u0011\t\u0019$a\u0006\u0003\u000f\tcwnY6JI\"1\u0011qG\u000bA\u00025\u000b\u0001B\\;n\u0005f$Xm\u001d\u0005\b\u0003w)\u0002\u0019AA\u001f\u0003)iW-\\8ss6{G-\u001a\t\u0004)\u0006}\u0012bAA![\tQQ*Z7peflu\u000eZ3\u0002'\u0005\u001c\u0017/^5sKVs'o\u001c7m\u001b\u0016lwN]=\u0015\u0011\u0005\r\u0012qIA%\u0003\u0017Bq!a\u000b\u0017\u0001\u0004\ti\u0003\u0003\u0004\u00028Y\u0001\r!\u0014\u0005\b\u0003w1\u0002\u0019AA\u001f\u0003Y\t7-];je\u0016,\u00050Z2vi&|g.T3n_JLHcB'\u0002R\u0005M\u0013q\u000b\u0005\u0007\u0003o9\u0002\u0019A'\t\r\u0005Us\u00031\u0001N\u00035!\u0018m]6BiR,W\u000e\u001d;JI\"9\u00111H\fA\u0002\u0005u\u0012A\u0006:fY\u0016\f7/Z#yK\u000e,H/[8o\u001b\u0016lwN]=\u0015\u0011\u0005\u001d\u0011QLA0\u0003CBa!a\u000e\u0019\u0001\u0004i\u0005BBA+1\u0001\u0007Q\nC\u0004\u0002<a\u0001\r!!\u0010\u0002AI,G.Z1tK\u0006cG.\u0012=fGV$\u0018n\u001c8NK6|'/\u001f$peR\u000b7o\u001b\u000b\u0004\u001b\u0006\u001d\u0004BBA+3\u0001\u0007Q*\u0001\u000bsK2,\u0017m]3Ti>\u0014\u0018mZ3NK6|'/\u001f\u000b\u0007\u0003\u000f\ti'a\u001c\t\r\u0005]\"\u00041\u0001N\u0011\u001d\tYD\u0007a\u0001\u0003{\tqC]3mK\u0006\u001cX-\u00117m'R|'/Y4f\u001b\u0016lwN]=\u0015\u0005\u0005\u001d\u0011a\u0005:fY\u0016\f7/Z+oe>dG.T3n_JLHCBA\u0004\u0003s\nY\b\u0003\u0004\u00028q\u0001\r!\u0014\u0005\b\u0003wa\u0002\u0019AA\u001f\u0003M)\u00070Z2vi&|g.T3n_JLXk]3e\u0003E\u0019Ho\u001c:bO\u0016lU-\\8ssV\u001bX\rZ\u0001\u001a_:DU-\u00199Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z+N,G-\u0001\u000epM\u001aDU-\u00199Fq\u0016\u001cW\u000f^5p]6+Wn\u001c:z+N,G-A\fp]\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u00180V:fI\u0006ArN\u001a4IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef,6/\u001a3\u0002=\u001d,G/\u0012=fGV$\u0018n\u001c8NK6|'/_+tC\u001e,gi\u001c:UCN\\GcA'\u0002\u000e\"1\u0011QK\u0012A\u00025\u000b!\u0003^;oON$XM\\'f[>\u0014\u00180T8eKV\u0011\u0011QH\u0001\u0014iVtwm\u001d;f]6+Wn\u001c:z\u001b>$W\rI\u0001\u0015I\u00164\u0017-\u001e7u!\u0006<WmU5{K\nKH/Z:\u0002\u001bA\fw-Z*ju\u0016\u0014\u0015\u0010^3t\u00039\u0001\u0018mZ3TSj,')\u001f;fg\u0002\nq\u0003^;oON$XM\\'f[>\u0014\u00180\u00117m_\u000e\fGo\u001c:\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Sk!!a)\u000b\u00079\n)KC\u0002\u0002(>\na!\u001e8tC\u001a,\u0017\u0002BAV\u0003G\u0013q\"T3n_JL\u0018\t\u001c7pG\u0006$xN]\u0001\u0019iVtwm\u001d;f]6+Wn\u001c:z\u00032dwnY1u_J\u0004\u0013AB5t\u000fF:5)\u0006\u0002\u0002$\u0001")
public abstract class MemoryManager
implements Logging {
    private long defaultPageSizeBytes;
    private boolean isG1GC;
    private final int numCores;
    @GuardedBy(value="this")
    private final StorageMemoryPool onHeapStorageMemoryPool;
    @GuardedBy(value="this")
    private final StorageMemoryPool offHeapStorageMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool onHeapExecutionMemoryPool;
    @GuardedBy(value="this")
    private final ExecutionMemoryPool offHeapExecutionMemoryPool;
    private final long maxOffHeapMemory;
    private final long offHeapStorageMemory;
    private final MemoryMode tungstenMemoryMode;
    private final long pageSizeBytes;
    private final MemoryAllocator tungstenMemoryAllocator;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StorageMemoryPool onHeapStorageMemoryPool() {
        return this.onHeapStorageMemoryPool;
    }

    public StorageMemoryPool offHeapStorageMemoryPool() {
        return this.offHeapStorageMemoryPool;
    }

    public ExecutionMemoryPool onHeapExecutionMemoryPool() {
        return this.onHeapExecutionMemoryPool;
    }

    public ExecutionMemoryPool offHeapExecutionMemoryPool() {
        return this.offHeapExecutionMemoryPool;
    }

    public long maxOffHeapMemory() {
        return this.maxOffHeapMemory;
    }

    public long offHeapStorageMemory() {
        return this.offHeapStorageMemory;
    }

    public abstract long maxOnHeapStorageMemory();

    public abstract long maxOffHeapStorageMemory();

    public final synchronized void setMemoryStore(MemoryStore store) {
        this.onHeapStorageMemoryPool().setMemoryStore(store);
        this.offHeapStorageMemoryPool().setMemoryStore(store);
    }

    public abstract boolean acquireStorageMemory(BlockId var1, long var2, MemoryMode var4);

    public abstract boolean acquireUnrollMemory(BlockId var1, long var2, MemoryMode var4);

    public abstract long acquireExecutionMemory(long var1, long var3, MemoryMode var5);

    public synchronized void releaseExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            this.onHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            this.offHeapExecutionMemoryPool().releaseMemory(numBytes, taskAttemptId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
    }

    public synchronized long releaseAllExecutionMemoryForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().releaseAllMemoryForTask(taskAttemptId);
    }

    public synchronized void releaseStorageMemory(long numBytes, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            this.onHeapStorageMemoryPool().releaseMemory(numBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            this.offHeapStorageMemoryPool().releaseMemory(numBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
    }

    public final synchronized void releaseAllStorageMemory() {
        this.onHeapStorageMemoryPool().releaseAllMemory();
        this.offHeapStorageMemoryPool().releaseAllMemory();
    }

    public final synchronized void releaseUnrollMemory(long numBytes, MemoryMode memoryMode) {
        this.releaseStorageMemory(numBytes, memoryMode);
    }

    public final synchronized long executionMemoryUsed() {
        return this.onHeapExecutionMemoryPool().memoryUsed() + this.offHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long storageMemoryUsed() {
        return this.onHeapStorageMemoryPool().memoryUsed() + this.offHeapStorageMemoryPool().memoryUsed();
    }

    public final synchronized long onHeapExecutionMemoryUsed() {
        return this.onHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long offHeapExecutionMemoryUsed() {
        return this.offHeapExecutionMemoryPool().memoryUsed();
    }

    public final synchronized long onHeapStorageMemoryUsed() {
        return this.onHeapStorageMemoryPool().memoryUsed();
    }

    public final synchronized long offHeapStorageMemoryUsed() {
        return this.offHeapStorageMemoryPool().memoryUsed();
    }

    public synchronized long getExecutionMemoryUsageForTask(long taskAttemptId) {
        return this.onHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId) + this.offHeapExecutionMemoryPool().getMemoryUsageForTask(taskAttemptId);
    }

    public final MemoryMode tungstenMemoryMode() {
        return this.tungstenMemoryMode;
    }

    /*
     * Unable to fully structure code
     */
    private long defaultPageSizeBytes$lzycompute() {
        block9: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((byte)(this.bitmap$0 & 1) != 0) break block9;
                minPageSize = 0x100000L;
                maxPageSize = 64L * minPageSize;
                cores = this.numCores > 0 ? this.numCores : Runtime.getRuntime().availableProcessors();
                safetyFactor = 16;
                var12_6 = this.tungstenMemoryMode();
                if (MemoryMode.ON_HEAP.equals((Object)var12_6)) {
                    var1_7 = this.onHeapExecutionMemoryPool().poolSize();
                } else if (MemoryMode.OFF_HEAP.equals((Object)var12_6)) {
                    var1_7 = this.offHeapExecutionMemoryPool().poolSize();
                } else {
                    throw new MatchError((Object)var12_6);
                }
                maxTungstenMemory = var1_7;
                size = ByteArrayMethods.nextPowerOf2((long)(maxTungstenMemory / (long)cores / (long)safetyFactor));
                chosenPageSize = package$.MODULE$.min(maxPageSize, package$.MODULE$.max(minPageSize, size));
                if (!this.isG1GC()) ** GOTO lbl-1000
                v0 = this.tungstenMemoryMode();
                var17_11 = MemoryMode.ON_HEAP;
                if (!(v0 != null ? v0.equals((Object)var17_11) == false : var17_11 != null)) {
                    v1 = chosenPageSize - (long)Platform.LONG_ARRAY_OFFSET;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = chosenPageSize;
                }
                this.defaultPageSizeBytes = v1;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultPageSizeBytes;
    }

    private long defaultPageSizeBytes() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultPageSizeBytes$lzycompute() : this.defaultPageSizeBytes;
    }

    public long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public final MemoryAllocator tungstenMemoryAllocator() {
        return this.tungstenMemoryAllocator;
    }

    private boolean isG1GC$lzycompute() {
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isG1GC = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Class clazz = Utils$.MODULE$.classForName("com.sun.management.HotSpotDiagnosticMXBean", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
                    Class vmOptionClazz = Utils$.MODULE$.classForName("com.sun.management.VMOption", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
                    Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(clazz);
                    Method vmOptionMethod = clazz.getMethod("getVMOption", String.class);
                    Method valueMethod = vmOptionClazz.getMethod("getValue", new Class[0]);
                    Object useG1GCObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseG1GC");
                    String useG1GC = (String)valueMethod.invoke(useG1GCObject, new Object[0]);
                    return "true".equals(useG1GC);
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isG1GC;
    }

    private boolean isG1GC() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.isG1GC$lzycompute() : this.isG1GC;
    }

    public MemoryManager(SparkConf conf, int numCores, long onHeapStorageMemory, long onHeapExecutionMemory) {
        MemoryAllocator memoryAllocator;
        MemoryMode memoryMode;
        this.numCores = numCores;
        Logging.$init$(this);
        Predef$.MODULE$.require(onHeapExecutionMemory > 0L, (Function0 & Serializable & scala.Serializable)() -> "onHeapExecutionMemory must be > 0");
        this.onHeapStorageMemoryPool = new StorageMemoryPool(this, MemoryMode.ON_HEAP);
        this.offHeapStorageMemoryPool = new StorageMemoryPool(this, MemoryMode.OFF_HEAP);
        this.onHeapExecutionMemoryPool = new ExecutionMemoryPool(this, MemoryMode.ON_HEAP);
        this.offHeapExecutionMemoryPool = new ExecutionMemoryPool(this, MemoryMode.OFF_HEAP);
        this.onHeapStorageMemoryPool().incrementPoolSize(onHeapStorageMemory);
        this.onHeapExecutionMemoryPool().incrementPoolSize(onHeapExecutionMemory);
        this.maxOffHeapMemory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE()));
        this.offHeapStorageMemory = (long)((double)this.maxOffHeapMemory() * BoxesRunTime.unboxToDouble((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_STORAGE_FRACTION())));
        this.offHeapExecutionMemoryPool().incrementPoolSize(this.maxOffHeapMemory() - this.offHeapStorageMemory());
        this.offHeapStorageMemoryPool().incrementPoolSize(this.offHeapStorageMemory());
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED()))) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE())) > 0L, (Function0 & Serializable & scala.Serializable)() -> "spark.memory.offHeap.size must be > 0 when spark.memory.offHeap.enabled == true");
            Predef$.MODULE$.require(Platform.unaligned(), (Function0 & Serializable & scala.Serializable)() -> "No support for unaligned Unsafe. Set spark.memory.offHeap.enabled to false.");
            memoryMode = MemoryMode.OFF_HEAP;
        } else {
            memoryMode = MemoryMode.ON_HEAP;
        }
        this.tungstenMemoryMode = memoryMode;
        this.pageSizeBytes = BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.BUFFER_PAGESIZE())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.defaultPageSizeBytes()));
        MemoryMode memoryMode2 = this.tungstenMemoryMode();
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            memoryAllocator = MemoryAllocator.HEAP;
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            memoryAllocator = MemoryAllocator.UNSAFE;
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        this.tungstenMemoryAllocator = memoryAllocator;
    }
}

