/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.inbox;

import com.google.common.base.Preconditions;
import io.reactivex.rxjava3.core.Observable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.mqtt.inbox.DeliveryPipeline;
import org.apache.bifromq.mqtt.inbox.IMqttBrokerClient;
import org.apache.bifromq.mqtt.inbox.rpc.proto.BrokerServiceGrpc;
import org.apache.bifromq.mqtt.inbox.rpc.proto.InboxStateReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.InboxStateRequest;
import org.apache.bifromq.mqtt.inbox.rpc.proto.SubReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.SubRequest;
import org.apache.bifromq.mqtt.inbox.rpc.proto.UnsubReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.UnsubRequest;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteRequest;
import org.apache.bifromq.mqtt.inbox.util.DelivererKeyUtil;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.QoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MqttBrokerClient
implements IMqttBrokerClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttBrokerClient.class);
    private final AtomicBoolean hasStopped = new AtomicBoolean();
    private final IRPCClient rpcClient;

    MqttBrokerClient(IRPCClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public CompletableFuture<CheckReply> check(CheckRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), DelivererKeyUtil.parseServerId((String)request.getDelivererKey()), (Object)request, BrokerServiceGrpc.getCheckSubscriptionsMethod()).exceptionally(CompletableFutureUtil.unwrap(e -> {
            log.debug("Failed to handle CheckRequest", e);
            CheckReply.Builder replyBuilder = CheckReply.newBuilder();
            CheckReply.Code code = e instanceof ServerNotFoundException ? CheckReply.Code.NO_RECEIVER : CheckReply.Code.ERROR;
            for (MatchInfo matchInfo : request.getMatchInfoList()) {
                replyBuilder.addCode(code);
            }
            return replyBuilder.build();
        }));
    }

    public IDeliverer open(String delivererKey) {
        Preconditions.checkState((!this.hasStopped.get() ? 1 : 0) != 0);
        IRPCClient.IRequestPipeline ppln = this.rpcClient.createRequestPipeline(DelivererKeyUtil.parseTenantId((String)delivererKey), DelivererKeyUtil.parseServerId((String)delivererKey), null, Collections.emptyMap(), BrokerServiceGrpc.getWriteMethod());
        return new DeliveryPipeline((IRPCClient.IRequestPipeline<WriteRequest, WriteReply>)ppln);
    }

    @Override
    public void close() {
        if (this.hasStopped.compareAndSet(false, true)) {
            log.debug("Closing MQTT broker client");
            log.debug("Stopping rpc client");
            this.rpcClient.stop();
            log.debug("MQTT broker client closed");
        }
    }

    public Observable<IConnectable.ConnState> connState() {
        return this.rpcClient.connState();
    }

    @Override
    public CompletableFuture<InboxStateReply> inboxState(long reqId, String tenantId, String sessionId, String brokerServerId) {
        return this.rpcClient.invoke(tenantId, brokerServerId, (Object)InboxStateRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setSessionId(sessionId).setNow(HLC.INST.getPhysical()).build(), BrokerServiceGrpc.getStateMethod()).exceptionally(e -> {
            log.debug("Failed to handle InboxStateRequest", e);
            return InboxStateReply.newBuilder().setReqId(reqId).setCode(InboxStateReply.Code.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<SubReply> sub(long reqId, String tenantId, String sessionId, String topicFilter, QoS qos, String brokerServerId) {
        return this.rpcClient.invoke(tenantId, brokerServerId, (Object)SubRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setSessionId(sessionId).setTopicFilter(topicFilter).setSubQoS(qos).build(), BrokerServiceGrpc.getSubMethod()).exceptionally(e -> {
            log.debug("Failed to handle SubRequest", e);
            return SubReply.newBuilder().setReqId(reqId).setResult(SubReply.Result.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<UnsubReply> unsub(long reqId, String tenantId, String sessionId, String topicFilter, String brokerServerId) {
        return this.rpcClient.invoke(tenantId, brokerServerId, (Object)UnsubRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setSessionId(sessionId).setTopicFilter(topicFilter).build(), BrokerServiceGrpc.getUnsubMethod()).exceptionally(e -> {
            log.debug("Failed to handle UnsubRequest", e);
            return UnsubReply.newBuilder().setResult(UnsubReply.Result.ERROR).build();
        });
    }
}

