/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.ByteBuffer;

public class BSUtil {
    public static long toLong(ByteString b) {
        assert (b.size() == 8);
        ByteBuffer buffer = b.asReadOnlyByteBuffer();
        return buffer.getLong();
    }

    public static byte[] toBytes(long l) {
        return ByteBuffer.allocate(8).putLong(l).array();
    }

    public static ByteString toByteString(long l) {
        return UnsafeByteOperations.unsafeWrap((byte[])BSUtil.toBytes(l));
    }

    public static int toInt(ByteString b) {
        assert (b.size() == 4);
        ByteBuffer buffer = b.asReadOnlyByteBuffer();
        return buffer.getInt();
    }

    public static ByteString toByteString(int i) {
        return UnsafeByteOperations.unsafeWrap((byte[])BSUtil.toBytes(i));
    }

    public static byte[] toBytes(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    public static short toShort(ByteString s) {
        assert (s.size() == 2);
        ByteBuffer buffer = s.asReadOnlyByteBuffer();
        return buffer.getShort();
    }

    public static byte[] toBytes(short s) {
        return ByteBuffer.allocate(2).putShort(s).array();
    }

    public static ByteString toByteString(short s) {
        return UnsafeByteOperations.unsafeWrap((byte[])BSUtil.toBytes(s));
    }
}

