/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.gravitino.utils.ThrowableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoader
implements Closeable {
    public static final Class<?> CUSTOM_CLASS_LOADER_CLASS = CustomURLClassLoader.class;
    private static final Logger LOG = LoggerFactory.getLogger(IsolatedClassLoader.class);
    private final List<URL> execJars;
    private final List<String> sharedClasses;
    private final List<String> barrierClasses;
    private URLClassLoader classLoader;
    private final ClassLoader baseClassLoader;

    public IsolatedClassLoader(List<URL> execJars, List<String> sharedClasses, List<String> barrierClasses) {
        this.execJars = execJars;
        this.sharedClasses = sharedClasses;
        this.barrierClasses = barrierClasses;
        this.baseClassLoader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withClassLoader(ThrowableFunction<ClassLoader, T> fn) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader());
        try {
            T t = fn.apply(this.classLoader());
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public <T, E extends RuntimeException> T withClassLoader(ThrowableFunction<ClassLoader, T> fn, Class<E> exceptionClass) {
        try {
            return this.withClassLoader(fn);
        }
        catch (Exception e) {
            if (exceptionClass.isInstance(e)) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static IsolatedClassLoader buildClassLoader(List<String> libAndResourcesPaths) {
        ArrayList classPathContents = Lists.newArrayList();
        for (String path : libAndResourcesPaths) {
            File folder = new File(path);
            if (!(folder.exists() && folder.isDirectory() && folder.canRead() && folder.canExecute())) {
                throw new IllegalArgumentException(String.format("Invalid package path: %s in %s", path, libAndResourcesPaths));
            }
            Arrays.stream(folder.listFiles()).filter(f -> f.getName().endsWith(".jar")).forEach(f -> {
                try {
                    classPathContents.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Failed to read jar file: {}", (Object)f.getAbsolutePath(), (Object)e);
                }
            });
            try {
                classPathContents.add(folder.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.warn("Failed to read directory: {}", (Object)folder.getAbsolutePath(), (Object)e);
            }
        }
        return new IsolatedClassLoader(classPathContents, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public void close() {
        try {
            if (this.classLoader != null) {
                this.classLoader.close();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to close classloader", (Throwable)e);
        }
    }

    private synchronized URLClassLoader classLoader() throws Exception {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        this.classLoader = new CustomURLClassLoader(this.execJars.toArray(new URL[0]), parent, this.baseClassLoader);
        return this.classLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSharedClass(String name) {
        if (name.startsWith("org.slf4j")) return true;
        if (name.startsWith("org.apache.log4j")) return true;
        if (name.startsWith("org.apache.logging.log4j")) return true;
        if (name.startsWith("java.")) return true;
        if (!this.isCatalogClass(name)) return true;
        if (!this.sharedClasses.stream().anyMatch(name::startsWith)) return false;
        return true;
    }

    private boolean isCatalogClass(String name) {
        return name.startsWith("org.apache.gravitino.catalog") && (name.startsWith("org.apache.gravitino.catalog.hive.") || name.startsWith("org.apache.gravitino.catalog.lakehouse.") || name.startsWith("org.apache.gravitino.catalog.jdbc.") || name.startsWith("org.apache.gravitino.catalog.mysql.") || name.startsWith("org.apache.gravitino.catalog.postgresql.") || name.startsWith("org.apache.gravitino.catalog.doris.") || name.startsWith("org.apache.gravitino.catalog.hadoop.") || name.startsWith("org.apache.gravitino.catalog.kafka."));
    }

    private boolean isBarrierClass(String name) {
        return this.barrierClasses.stream().anyMatch(name::startsWith);
    }

    private ClassLoader getRootClassLoader() throws Exception {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        return null;
    }

    private byte[] loadClassBytes(String name) throws Exception {
        Throwable throwable = null;
        try (InputStream io = this.baseClassLoader.getResourceAsStream(this.classToPath(name));){
            if (io != null) {
                byte[] byArray = IOUtils.toByteArray((InputStream)io);
                return byArray;
            }
            try {
                throw new ClassNotFoundException("Class not found: " + name);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String classToPath(String name) {
        return name.replaceAll("\\.", "/") + ".class";
    }

    class CustomURLClassLoader
    extends URLClassLoader {
        private final ClassLoader baseClassLoader;

        public CustomURLClassLoader(URL[] urls, ClassLoader parent, ClassLoader baseClassLoader) {
            super(urls, parent);
            this.baseClassLoader = baseClassLoader;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            try {
                return clazz == null ? this.doLoadClass(name, resolve) : clazz;
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Class no found " + name, e);
            }
        }

        private Class<?> doLoadClass(String name, boolean resolve) throws Exception {
            if (IsolatedClassLoader.this.isBarrierClass(name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("barrier class: {}", (Object)name);
                }
                byte[] bytes = IsolatedClassLoader.this.loadClassBytes(name);
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            if (!IsolatedClassLoader.this.isSharedClass(name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("isolated class: {} - {}", (Object)name, this.getResources(IsolatedClassLoader.this.classToPath(name)));
                }
                return super.loadClass(name, resolve);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("shared class: {}", (Object)name);
            }
            try {
                return this.baseClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }
    }
}

