/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.types.Type;

public class ColumnEntity
implements Entity,
Auditable {
    public static final Field ID = Field.required("id", Long.class, "The column's unique identifier");
    public static final Field NAME = Field.required("name", String.class, "The column's name");
    public static final Field POSITION = Field.required("position", Integer.class, "The column's position");
    public static final Field TYPE = Field.required("dataType", Type.class, "The column's data type");
    public static final Field COMMENT = Field.optional("comment", String.class, "The column's comment");
    public static final Field NULLABLE = Field.required("nullable", Boolean.class, "The column's nullable property");
    public static final Field AUTO_INCREMENT = Field.required("auto_increment", Boolean.class, "The column's auto increment property");
    public static final Field DEFAULT_VALUE = Field.optional("default_value", Expression.class, "The column's default value");
    public static final Field AUDIT_INFO = Field.required("audit_info", Audit.class, "The column's audit information");
    private Long id;
    private String name;
    private Integer position;
    private Type dataType;
    private String comment;
    private boolean nullable;
    private boolean autoIncrement;
    private Expression defaultValue;
    private AuditInfo auditInfo;

    private ColumnEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(POSITION, this.position);
        fields.put(TYPE, this.dataType);
        fields.put(COMMENT, this.comment);
        fields.put(NULLABLE, this.nullable);
        fields.put(AUTO_INCREMENT, this.autoIncrement);
        fields.put(DEFAULT_VALUE, this.defaultValue);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.COLUMN;
    }

    public Audit auditInfo() {
        return this.auditInfo;
    }

    public Long id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Integer position() {
        return this.position;
    }

    public Type dataType() {
        return this.dataType;
    }

    public String comment() {
        return this.comment;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public Expression defaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnEntity)) {
            return false;
        }
        ColumnEntity that = (ColumnEntity)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.position, (Object)that.position) && Objects.equal((Object)this.dataType, (Object)that.dataType) && Objects.equal((Object)this.comment, (Object)that.comment) && Objects.equal((Object)this.nullable, (Object)that.nullable) && Objects.equal((Object)this.autoIncrement, (Object)that.autoIncrement) && Objects.equal((Object)this.defaultValue, (Object)that.defaultValue) && Objects.equal((Object)this.auditInfo, (Object)that.auditInfo);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.position, this.dataType, this.comment, this.nullable, this.autoIncrement, this.defaultValue, this.auditInfo});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ColumnEntity toColumnEntity(Column column, int position, long uid, AuditInfo audit) {
        return ColumnEntity.builder().withId(uid).withName(column.name()).withPosition(position).withComment(column.comment()).withDataType(column.dataType()).withNullable(column.nullable()).withAutoIncrement(column.autoIncrement()).withDefaultValue(column.defaultValue()).withAuditInfo(audit).build();
    }

    public String toString() {
        return "ColumnEntity(id=" + this.id + ", name=" + this.name + ", position=" + this.position + ", dataType=" + this.dataType + ", comment=" + this.comment + ", nullable=" + this.nullable + ", autoIncrement=" + this.autoIncrement + ", defaultValue=" + this.defaultValue + ", auditInfo=" + this.auditInfo + ")";
    }

    public static class Builder {
        private final ColumnEntity columnEntity = new ColumnEntity();

        public Builder withId(Long id) {
            this.columnEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.columnEntity.name = name;
            return this;
        }

        public Builder withPosition(Integer position) {
            this.columnEntity.position = position;
            return this;
        }

        public Builder withDataType(Type dataType) {
            this.columnEntity.dataType = dataType;
            return this;
        }

        public Builder withComment(String comment) {
            this.columnEntity.comment = comment;
            return this;
        }

        public Builder withNullable(boolean nullable) {
            this.columnEntity.nullable = nullable;
            return this;
        }

        public Builder withAutoIncrement(boolean autoIncrement) {
            this.columnEntity.autoIncrement = autoIncrement;
            return this;
        }

        public Builder withDefaultValue(Expression defaultValue) {
            this.columnEntity.defaultValue = defaultValue;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.columnEntity.auditInfo = auditInfo;
            return this;
        }

        public ColumnEntity build() {
            this.columnEntity.validate();
            if (this.columnEntity.defaultValue == null) {
                this.columnEntity.defaultValue = Column.DEFAULT_VALUE_NOT_SET;
            }
            return this.columnEntity;
        }
    }
}

