/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.TimeZone;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.BinaryStringUtils;
import org.apache.paimon.utils.DateTimeUtils;

class StringToTimestampCastRule
extends AbstractCastRule<BinaryString, Timestamp> {
    static final StringToTimestampCastRule INSTANCE = new StringToTimestampCastRule();

    private StringToTimestampCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeFamily.TIMESTAMP).build());
    }

    @Override
    public CastExecutor<BinaryString, Timestamp> create(DataType inputType, DataType targetType) {
        int targetPrecision = DataTypeChecks.getPrecision((DataType)targetType);
        if (targetType.is(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return value -> BinaryStringUtils.toTimestamp((BinaryString)value, (int)targetPrecision);
        }
        if (targetType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return value -> BinaryStringUtils.toTimestamp((BinaryString)value, (int)targetPrecision, (TimeZone)DateTimeUtils.LOCAL_TZ);
        }
        return null;
    }
}

