/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.TimeZone;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DateTimeUtils;

class TimestampToDateCastRule
extends AbstractCastRule<Timestamp, Number> {
    static final TimestampToDateCastRule INSTANCE = new TimestampToDateCastRule();

    private TimestampToDateCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).input(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).target(DataTypeRoot.DATE).build());
    }

    @Override
    public CastExecutor<Timestamp, Number> create(DataType inputType, DataType targetType) {
        if (inputType.is(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return value -> (int)(value.getMillisecond() / 86400000L);
        }
        if (inputType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return value -> DateTimeUtils.timestampWithLocalZoneToDate((Timestamp)value, (TimeZone)DateTimeUtils.LOCAL_TZ);
        }
        return null;
    }
}

