/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.Preconditions;

@Public
public interface CatalogFactory
extends Factory {
    default public Catalog create(FileIO fileIO, Path warehouse, CatalogContext context) {
        throw new UnsupportedOperationException("Use  create(context) for " + this.getClass().getSimpleName());
    }

    default public Catalog create(CatalogContext context) {
        throw new UnsupportedOperationException("Use create(fileIO, warehouse, context) for " + this.getClass().getSimpleName());
    }

    public static Path warehouse(CatalogContext context) {
        String warehouse = (String)Preconditions.checkNotNull((Object)context.options().get(CatalogOptions.WAREHOUSE), (String)("Paimon '" + CatalogOptions.WAREHOUSE.key() + "' path must be set"));
        return new Path(warehouse);
    }

    public static Catalog createCatalog(CatalogContext options) {
        return CatalogFactory.createCatalog(options, CatalogFactory.class.getClassLoader());
    }

    public static Catalog createCatalog(CatalogContext context, ClassLoader classLoader) {
        Options options = context.options();
        String metastore = (String)options.get(CatalogOptions.METASTORE);
        CatalogFactory catalogFactory = (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, CatalogFactory.class, (String)metastore);
        try {
            return catalogFactory.create(context);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            FileIO fileIO;
            String warehouse = CatalogFactory.warehouse(context).toUri().toString();
            Path warehousePath = new Path(warehouse);
            try {
                fileIO = FileIO.get((Path)warehousePath, (CatalogContext)context);
                fileIO.checkOrMkdirs(warehousePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return catalogFactory.create(fileIO, warehousePath, context);
        }
    }
}

