/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.crosspartition;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.paimon.crosspartition.ExistingProcessor;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.utils.ProjectToRowFunction;
import org.apache.paimon.utils.RowIterator;

public class UseOldExistingProcessor
implements ExistingProcessor {
    private final ProjectToRowFunction setPartition;
    private final BiConsumer<InternalRow, Integer> collector;

    public UseOldExistingProcessor(ProjectToRowFunction setPartition, BiConsumer<InternalRow, Integer> collector) {
        this.setPartition = setPartition;
        this.collector = collector;
    }

    @Override
    public boolean processExists(InternalRow newRow, BinaryRow previousPart, int previousBucket) {
        InternalRow newValue = this.setPartition.apply(newRow, previousPart);
        this.collector.accept(newValue, previousBucket);
        return false;
    }

    @Override
    public void bulkLoadNewRecords(Function<ExistingProcessor.SortOrder, RowIterator> iteratorFunction, Function<InternalRow, BinaryRow> extractPrimary, Function<InternalRow, BinaryRow> extractPartition, Function<BinaryRow, Integer> assignBucket) {
        InternalRow row;
        RowIterator iterator = iteratorFunction.apply(ExistingProcessor.SortOrder.ASCENDING);
        BinaryRow currentKey = null;
        BinaryRow currentPartition = null;
        int currentBucket = -1;
        while ((row = iterator.next()) != null) {
            BinaryRow primaryKey = extractPrimary.apply(row);
            BinaryRow partition = extractPartition.apply(row);
            if (currentKey == null || !currentKey.equals((Object)primaryKey)) {
                int bucket = assignBucket.apply(partition);
                this.collector.accept(row, bucket);
                currentKey = primaryKey.copy();
                currentPartition = partition.copy();
                currentBucket = bucket;
                continue;
            }
            InternalRow newRow = this.setPartition.apply(row, currentPartition);
            this.collector.accept(newRow, currentBucket);
        }
    }
}

