/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.BiFunctionWithIOE;

public class LookupUtils {
    public static <T> T lookup(Levels levels, InternalRow key, int startLevel, BiFunctionWithIOE<InternalRow, SortedRun, T> lookup, BiFunctionWithIOE<InternalRow, TreeSet<DataFileMeta>, T> level0Lookup) throws IOException {
        Object result = null;
        for (int i = startLevel; i < levels.numberOfLevels(); ++i) {
            if (i == 0) {
                result = level0Lookup.apply((Object)key, levels.level0());
            } else {
                SortedRun level = levels.runOfLevel(i);
                result = lookup.apply((Object)key, (Object)level);
            }
            if (result != null) break;
        }
        return (T)result;
    }

    public static <T> T lookupLevel0(Comparator<InternalRow> keyComparator, InternalRow target, TreeSet<DataFileMeta> level0, BiFunctionWithIOE<InternalRow, DataFileMeta, T> lookup) throws IOException {
        Object result = null;
        for (DataFileMeta file : level0) {
            if (keyComparator.compare((InternalRow)file.maxKey(), target) >= 0 && keyComparator.compare((InternalRow)file.minKey(), target) <= 0 && (result = lookup.apply((Object)target, (Object)file)) != null) break;
        }
        return (T)result;
    }

    public static <T> T lookup(Comparator<InternalRow> keyComparator, InternalRow target, SortedRun level, BiFunctionWithIOE<InternalRow, DataFileMeta, T> lookup) throws IOException {
        if (level.isEmpty()) {
            return null;
        }
        List<DataFileMeta> files = level.files();
        int left = 0;
        int right = files.size() - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (keyComparator.compare((InternalRow)files.get(mid).maxKey(), target) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        int index = right;
        if (index == files.size() - 1 && keyComparator.compare((InternalRow)files.get(index).maxKey(), target) < 0) {
            ++index;
        }
        return (T)(index < files.size() ? lookup.apply((Object)target, (Object)files.get(index)) : null);
    }

    public static int fileKibiBytes(File file) {
        long kibiBytes = file.length() >> 10;
        if (kibiBytes > Integer.MAX_VALUE) {
            throw new RuntimeException("Lookup file is too big: " + MemorySize.ofKibiBytes((long)kibiBytes));
        }
        return (int)kibiBytes;
    }
}

