/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class PartitionUtils {
    public static Pair<int[], int[][]> constructPartitionMapping(TableSchema dataSchema, int[][] projection) {
        return PartitionUtils.constructPartitionMapping(dataSchema.logicalRowType(), dataSchema.partitionKeys(), projection);
    }

    public static Pair<int[], int[][]> constructPartitionMapping(RowType rowType, List<String> partitions, int[][] projection) {
        List fields = rowType.getFieldNames();
        int[][] dataProjection = (int[][])Arrays.copyOf(projection, projection.length);
        int[] map = new int[dataProjection.length + 1];
        int pCount = 0;
        for (int i = 0; i < dataProjection.length; ++i) {
            String field = (String)fields.get(dataProjection[i][0]);
            if (partitions.contains(field)) {
                map[i] = -(partitions.indexOf(field) + 1);
                ++pCount;
                dataProjection[i][0] = -1;
                continue;
            }
            map[i] = i - pCount + 1;
        }
        if (pCount == 0) {
            return null;
        }
        int[][] projectionReturn = new int[dataProjection.length - pCount][];
        int count = 0;
        for (int i = 0; i < dataProjection.length; ++i) {
            if (dataProjection[i][0] == -1) continue;
            projectionReturn[count++] = dataProjection[i];
        }
        return Pair.of((Object)map, (Object)projectionReturn);
    }

    public static PartitionInfo create(@Nullable Pair<int[], RowType> pair, BinaryRow binaryRow) {
        return pair == null ? null : new PartitionInfo((int[])pair.getLeft(), (RowType)pair.getRight(), binaryRow);
    }
}

