/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class SinkRecord {
    private final BinaryRow partition;
    private final int bucket;
    private final BinaryRow primaryKey;
    private final InternalRow row;

    public SinkRecord(BinaryRow partition, int bucket, BinaryRow primaryKey, InternalRow row) {
        Preconditions.checkArgument((partition.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
        Preconditions.checkArgument((primaryKey.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
        this.partition = partition;
        this.bucket = bucket;
        this.primaryKey = primaryKey;
        this.row = row;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public BinaryRow primaryKey() {
        return this.primaryKey;
    }

    public InternalRow row() {
        return this.row;
    }
}

