/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.AbstractDataTableRead;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.ValueContentRowDataRecordIterator;
import org.apache.paimon.utils.LazyField;

public final class KeyValueTableRead
extends AbstractDataTableRead<KeyValue> {
    private final LazyField<MergeFileSplitRead> mergeRead = new LazyField(() -> this.createMergeRead(mergeReadSupplier));
    private final LazyField<RawFileSplitRead> batchRawRead = new LazyField(() -> this.createBatchRawRead(batchRawReadSupplier));
    private int[][] projection = null;
    private boolean forceKeepDelete = false;
    private Predicate predicate = null;
    private IOManager ioManager = null;

    public KeyValueTableRead(Supplier<MergeFileSplitRead> mergeReadSupplier, Supplier<RawFileSplitRead> batchRawReadSupplier, TableSchema schema) {
        super(schema);
    }

    private MergeFileSplitRead createMergeRead(Supplier<MergeFileSplitRead> readSupplier) {
        MergeFileSplitRead read = readSupplier.get().withKeyProjection(new int[0][]).withValueProjection(this.projection).withFilter(this.predicate).withIOManager(this.ioManager);
        if (this.forceKeepDelete) {
            read = read.forceKeepDelete();
        }
        return read;
    }

    private RawFileSplitRead createBatchRawRead(Supplier<RawFileSplitRead> readSupplier) {
        return readSupplier.get().withProjection(this.projection).withFilter(this.predicate);
    }

    @Override
    public void projection(int[][] projection) {
        if (this.mergeRead.initialized()) {
            ((MergeFileSplitRead)this.mergeRead.get()).withValueProjection(projection);
        }
        if (this.batchRawRead.initialized()) {
            ((RawFileSplitRead)this.batchRawRead.get()).withProjection(projection);
        }
        this.projection = projection;
    }

    @Override
    public InnerTableRead forceKeepDelete() {
        if (this.mergeRead.initialized()) {
            ((MergeFileSplitRead)this.mergeRead.get()).forceKeepDelete();
        }
        this.forceKeepDelete = true;
        return this;
    }

    @Override
    protected InnerTableRead innerWithFilter(Predicate predicate) {
        if (this.mergeRead.initialized()) {
            ((MergeFileSplitRead)this.mergeRead.get()).withFilter(predicate);
        }
        if (this.batchRawRead.initialized()) {
            ((RawFileSplitRead)this.batchRawRead.get()).withFilter(predicate);
        }
        this.predicate = predicate;
        return this;
    }

    @Override
    public TableRead withIOManager(IOManager ioManager) {
        if (this.mergeRead.initialized()) {
            ((MergeFileSplitRead)this.mergeRead.get()).withIOManager(ioManager);
        }
        this.ioManager = ioManager;
        return this;
    }

    @Override
    public RecordReader<InternalRow> reader(Split split) throws IOException {
        DataSplit dataSplit = (DataSplit)split;
        if (!this.forceKeepDelete && !dataSplit.isStreaming() && split.convertToRawFiles().isPresent()) {
            return ((RawFileSplitRead)this.batchRawRead.get()).createReader(dataSplit);
        }
        final RecordReader<KeyValue> reader = ((MergeFileSplitRead)this.mergeRead.get()).createReader(dataSplit);
        return new RecordReader<InternalRow>(){

            @Nullable
            public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
                RecordReader.RecordIterator batch = reader.readBatch();
                return batch == null ? null : new ValueContentRowDataRecordIterator((RecordReader.RecordIterator<KeyValue>)batch);
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }
}

