/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.LazyGenericRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.apache.paimon.utils.SerializationUtils;

public class FilesTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String FILES = "files";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", (DataType)SerializationUtils.newStringType(true)), new DataField(1, "bucket", (DataType)new IntType(false)), new DataField(2, "file_path", (DataType)SerializationUtils.newStringType(false)), new DataField(3, "file_format", (DataType)SerializationUtils.newStringType(false)), new DataField(4, "schema_id", (DataType)new BigIntType(false)), new DataField(5, "level", (DataType)new IntType(false)), new DataField(6, "record_count", (DataType)new BigIntType(false)), new DataField(7, "file_size_in_bytes", (DataType)new BigIntType(false)), new DataField(8, "min_key", (DataType)SerializationUtils.newStringType(true)), new DataField(9, "max_key", (DataType)SerializationUtils.newStringType(true)), new DataField(10, "null_value_counts", (DataType)SerializationUtils.newStringType(false)), new DataField(11, "min_value_stats", (DataType)SerializationUtils.newStringType(false)), new DataField(12, "max_value_stats", (DataType)SerializationUtils.newStringType(false)), new DataField(13, "min_sequence_number", (DataType)new BigIntType(true)), new DataField(14, "max_sequence_number", (DataType)new BigIntType(true)), new DataField(15, "creation_time", (DataType)DataTypes.TIMESTAMP_MILLIS())));
    private final FileStoreTable storeTable;

    public FilesTable(FileStoreTable storeTable) {
        this.storeTable = storeTable;
    }

    @Override
    public String name() {
        return this.storeTable.name() + "$" + FILES;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("file_path");
    }

    @Override
    public InnerTableScan newScan() {
        return new FilesScan(this.storeTable);
    }

    @Override
    public InnerTableRead newRead() {
        return new FilesRead(new SchemaManager(this.storeTable.fileIO(), this.storeTable.location()), this.storeTable);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new FilesTable((FileStoreTable)this.storeTable.copy((Map)dynamicOptions));
    }

    private static class StatsLazyGetter {
        private final BinaryTableStats tableStats;
        private final DataFileMeta file;
        private final FieldStatsConverters fieldStatsConverters;
        private Map<String, Long> lazyNullValueCounts;
        private Map<String, Object> lazyLowerValueBounds;
        private Map<String, Object> lazyUpperValueBounds;

        private StatsLazyGetter(BinaryTableStats tableStats, DataFileMeta file, FieldStatsConverters fieldStatsConverters) {
            this.tableStats = tableStats;
            this.file = file;
            this.fieldStatsConverters = fieldStatsConverters;
        }

        private void initialize() {
            FieldStatsArraySerializer serializer = this.fieldStatsConverters.getOrCreate(this.file.schemaId());
            InternalRow min = serializer.evolution(this.tableStats.minValues());
            InternalRow max = serializer.evolution(this.tableStats.maxValues());
            InternalArray nullCounts = serializer.evolution(this.tableStats.nullCounts(), this.file.rowCount());
            this.lazyNullValueCounts = new TreeMap<String, Long>();
            this.lazyLowerValueBounds = new TreeMap<String, Object>();
            this.lazyUpperValueBounds = new TreeMap<String, Object>();
            for (int i = 0; i < min.getFieldCount(); ++i) {
                DataField field = this.fieldStatsConverters.tableDataFields().get(i);
                String name = field.name();
                DataType type = field.type();
                this.lazyNullValueCounts.put(name, nullCounts.isNullAt(i) ? null : Long.valueOf(nullCounts.getLong(i)));
                this.lazyLowerValueBounds.put(name, InternalRowUtils.get((DataGetters)min, (int)i, (DataType)type));
                this.lazyUpperValueBounds.put(name, InternalRowUtils.get((DataGetters)max, (int)i, (DataType)type));
            }
        }

        private Map<String, Long> nullValueCounts() {
            if (this.lazyNullValueCounts == null) {
                this.initialize();
            }
            return this.lazyNullValueCounts;
        }

        private Map<String, Object> lowerValueBounds() {
            if (this.lazyLowerValueBounds == null) {
                this.initialize();
            }
            return this.lazyLowerValueBounds;
        }

        private Map<String, Object> upperValueBounds() {
            if (this.lazyUpperValueBounds == null) {
                this.initialize();
            }
            return this.lazyUpperValueBounds;
        }
    }

    private static class FilesRead
    implements InnerTableRead {
        private final SchemaManager schemaManager;
        private final FileStoreTable storeTable;
        private int[][] projection;

        private FilesRead(SchemaManager schemaManager, FileStoreTable fileStoreTable) {
            this.schemaManager = schemaManager;
            this.storeTable = fileStoreTable;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof FilesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            FilesSplit filesSplit = (FilesSplit)split;
            if (filesSplit.splits().isEmpty()) {
                return new IteratorRecordReader<InternalRow>(Collections.emptyIterator());
            }
            ArrayList<Iterator> iteratorList = new ArrayList<Iterator>();
            FieldStatsConverters fieldStatsConverters = new FieldStatsConverters(sid -> this.schemaManager.schema((long)sid).fields(), this.storeTable.schema().id());
            RowDataToObjectArrayConverter partitionConverter = new RowDataToObjectArrayConverter(this.storeTable.schema().logicalPartitionType());
            Function<Long, RowDataToObjectArrayConverter> keyConverters = new Function<Long, RowDataToObjectArrayConverter>(){
                final Map<Long, RowDataToObjectArrayConverter> keyConverterMap = new HashMap<Long, RowDataToObjectArrayConverter>();

                @Override
                public RowDataToObjectArrayConverter apply(Long schemaId) {
                    return this.keyConverterMap.computeIfAbsent(schemaId, k -> {
                        TableSchema dataSchema = schemaManager.schema(schemaId);
                        RowType keysType = dataSchema.logicalTrimmedPrimaryKeysType();
                        return keysType.getFieldCount() > 0 ? new RowDataToObjectArrayConverter(dataSchema.logicalTrimmedPrimaryKeysType()) : new RowDataToObjectArrayConverter(dataSchema.logicalRowType());
                    });
                }
            };
            for (Split dataSplit : filesSplit.splits()) {
                iteratorList.add(Iterators.transform(((DataSplit)dataSplit).dataFiles().iterator(), file -> this.toRow((DataSplit)dataSplit, partitionConverter, keyConverters, (DataFileMeta)file, this.storeTable.getSchemaFieldStats((DataFileMeta)file), fieldStatsConverters)));
            }
            Iterator rows = Iterators.concat(iteratorList.iterator());
            if (this.projection != null) {
                rows = Iterators.transform((Iterator)rows, row -> ProjectedRow.from((int[][])this.projection).replaceRow(row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private LazyGenericRow toRow(DataSplit dataSplit, RowDataToObjectArrayConverter partitionConverter, Function<Long, RowDataToObjectArrayConverter> keyConverters, DataFileMeta dataFileMeta, BinaryTableStats tableStats, FieldStatsConverters fieldStatsConverters) {
            StatsLazyGetter statsGetter = new StatsLazyGetter(tableStats, dataFileMeta, fieldStatsConverters);
            Supplier[] supplierArray = new Supplier[16];
            supplierArray[0] = () -> dataSplit.partition() == null ? null : BinaryString.fromString((String)Arrays.toString(partitionConverter.convert((InternalRow)dataSplit.partition())));
            supplierArray[1] = dataSplit::bucket;
            supplierArray[2] = () -> BinaryString.fromString((String)dataFileMeta.fileName());
            supplierArray[3] = () -> BinaryString.fromString((String)DataFilePathFactory.formatIdentifier(dataFileMeta.fileName()));
            supplierArray[4] = dataFileMeta::schemaId;
            supplierArray[5] = dataFileMeta::level;
            supplierArray[6] = dataFileMeta::rowCount;
            supplierArray[7] = dataFileMeta::fileSize;
            supplierArray[8] = () -> dataFileMeta.minKey().getFieldCount() <= 0 ? null : BinaryString.fromString((String)Arrays.toString(((RowDataToObjectArrayConverter)keyConverters.apply(dataFileMeta.schemaId())).convert((InternalRow)dataFileMeta.minKey())));
            supplierArray[9] = () -> dataFileMeta.maxKey().getFieldCount() <= 0 ? null : BinaryString.fromString((String)Arrays.toString(((RowDataToObjectArrayConverter)keyConverters.apply(dataFileMeta.schemaId())).convert((InternalRow)dataFileMeta.maxKey())));
            supplierArray[10] = () -> BinaryString.fromString((String)statsGetter.nullValueCounts().toString());
            supplierArray[11] = () -> BinaryString.fromString((String)statsGetter.lowerValueBounds().toString());
            supplierArray[12] = () -> BinaryString.fromString((String)statsGetter.upperValueBounds().toString());
            supplierArray[13] = dataFileMeta::minSequenceNumber;
            supplierArray[14] = dataFileMeta::maxSequenceNumber;
            supplierArray[15] = dataFileMeta::creationTime;
            Supplier[] fields = supplierArray;
            return new LazyGenericRow(fields);
        }
    }

    private static class FilesSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final List<Split> splits;

        private FilesSplit(List<Split> splits) {
            this.splits = splits;
        }

        @Override
        public long rowCount() {
            return this.splits.stream().map(s -> (DataSplit)s).mapToLong(s -> s.dataFiles().size()).sum();
        }

        public List<Split> splits() {
            return this.splits;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilesSplit that = (FilesSplit)o;
            return Objects.equals(this.splits, that.splits);
        }

        public int hashCode() {
            return Objects.hash(this.splits);
        }
    }

    private static class FilesScan
    extends ReadOnceTableScan {
        private final FileStoreTable storeTable;
        @Nullable
        private LeafPredicate partitionPredicate;
        @Nullable
        private LeafPredicate bucketPredicate;
        @Nullable
        private LeafPredicate levelPredicate;

        private FilesScan(FileStoreTable storeTable) {
            this.storeTable = storeTable;
        }

        @Override
        public InnerTableScan withFilter(Predicate pushdown) {
            List predicates = PredicateBuilder.splitAnd((Predicate)pushdown);
            for (Predicate predicate : predicates) {
                if (!(predicate instanceof LeafPredicate)) continue;
                LeafPredicate leaf = (LeafPredicate)predicate;
                switch (leaf.fieldName()) {
                    case "partition": {
                        this.partitionPredicate = leaf;
                        break;
                    }
                    case "bucket": {
                        this.bucketPredicate = leaf;
                        break;
                    }
                    case "level": {
                        this.levelPredicate = leaf;
                        break;
                    }
                }
            }
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            TableScan.Plan plan = this.tablePlan();
            return () -> Collections.singletonList(new FilesSplit(plan.splits()));
        }

        private TableScan.Plan tablePlan() {
            InnerTableScan scan = this.storeTable.newScan();
            if (this.partitionPredicate != null && this.partitionPredicate.function() instanceof Equal) {
                String partitionStr = this.partitionPredicate.literals().get(0).toString();
                if (partitionStr.startsWith("[")) {
                    partitionStr = partitionStr.substring(1);
                }
                if (partitionStr.endsWith("]")) {
                    partitionStr = partitionStr.substring(0, partitionStr.length() - 1);
                }
                String[] partFields = partitionStr.split(", ");
                LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
                List<String> partitionKeys = this.storeTable.partitionKeys();
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partSpec.put(partitionKeys.get(i), partFields[i]);
                }
                scan.withPartitionFilter(partSpec);
            }
            if (this.bucketPredicate != null) {
                scan.withBucketFilter((Filter<Integer>)((Filter)bucket -> this.bucketPredicate.test((InternalRow)GenericRow.of((Object[])new Object[]{null, bucket}))));
            }
            if (this.levelPredicate != null) {
                scan.withLevelFilter((Filter<Integer>)((Filter)level -> this.levelPredicate.test((InternalRow)GenericRow.of((Object[])new Object[]{null, null, null, null, null, level}))));
            }
            return scan.plan();
        }
    }
}

