/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.lineage.LineageMeta;
import org.apache.paimon.lineage.LineageMetaFactory;
import org.apache.paimon.lineage.TableLineageEntity;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ProjectedRow;

public abstract class TableLineageTable
implements ReadonlyTable {
    protected final LineageMetaFactory lineageMetaFactory;
    protected final Options options;

    protected TableLineageTable(LineageMetaFactory lineageMetaFactory, Options options) {
        this.lineageMetaFactory = lineageMetaFactory;
        this.options = options;
    }

    @Override
    public InnerTableScan newScan() {
        return new ReadOnceTableScan(){

            @Override
            public InnerTableScan withFilter(Predicate predicate) {
                return this;
            }

            @Override
            protected TableScan.Plan innerPlan() {
                return () -> Collections.singletonList(() -> 1L);
            }
        };
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "database_name", (DataType)new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(1, "table_name", (DataType)new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(2, "job_name", (DataType)new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(3, "create_time", (DataType)new TimestampType()));
        return new RowType(fields);
    }

    @Override
    public List<String> primaryKeys() {
        return Arrays.asList("database_name", "table_name", "job_name");
    }

    protected static class TableLineageRead
    implements InnerTableRead {
        private final LineageMetaFactory lineageMetaFactory;
        private final Options options;
        private final BiFunction<LineageMeta, Predicate, Iterator<TableLineageEntity>> tableLineageQuery;
        @Nullable
        private Predicate predicate;
        private int[][] projection;

        protected TableLineageRead(LineageMetaFactory lineageMetaFactory, Options options, BiFunction<LineageMeta, Predicate, Iterator<TableLineageEntity>> tableLineageQuery) {
            this.lineageMetaFactory = lineageMetaFactory;
            this.options = options;
            this.tableLineageQuery = tableLineageQuery;
            this.predicate = null;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            try (LineageMeta lineageMeta = this.lineageMetaFactory.create(() -> this.options);){
                Iterator<TableLineageEntity> sourceTableLineages = this.tableLineageQuery.apply(lineageMeta, this.predicate);
                IteratorRecordReader<InternalRow> iteratorRecordReader = new IteratorRecordReader<InternalRow>(Iterators.transform(sourceTableLineages, entity -> {
                    Preconditions.checkNotNull((Object)entity);
                    GenericRow row = GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)entity.getDatabase()), BinaryString.fromString((String)entity.getTable()), BinaryString.fromString((String)entity.getJob()), entity.getCreateTime()});
                    if (this.projection != null) {
                        return ProjectedRow.from((int[][])this.projection).replaceRow((InternalRow)row);
                    }
                    return row;
                }));
                return iteratorRecordReader;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

