/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;

public class OffsetRow
implements InternalRow {
    private final int arity;
    private final int offset;
    private InternalRow row;

    public OffsetRow(int arity, int offset) {
        this.arity = arity;
        this.offset = offset;
    }

    public OffsetRow replace(InternalRow row) {
        this.row = row;
        return this;
    }

    public int getFieldCount() {
        return this.arity;
    }

    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    public boolean isNullAt(int pos) {
        return this.row.isNullAt(this.offset + pos);
    }

    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.offset + pos);
    }

    public byte getByte(int pos) {
        return this.row.getByte(this.offset + pos);
    }

    public short getShort(int pos) {
        return this.row.getShort(this.offset + pos);
    }

    public int getInt(int pos) {
        return this.row.getInt(this.offset + pos);
    }

    public long getLong(int pos) {
        return this.row.getLong(this.offset + pos);
    }

    public float getFloat(int pos) {
        return this.row.getFloat(this.offset + pos);
    }

    public double getDouble(int pos) {
        return this.row.getDouble(this.offset + pos);
    }

    public BinaryString getString(int pos) {
        return this.row.getString(this.offset + pos);
    }

    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.offset + pos, precision, scale);
    }

    public Timestamp getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.offset + pos, precision);
    }

    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.offset + pos);
    }

    public InternalArray getArray(int pos) {
        return this.row.getArray(this.offset + pos);
    }

    public InternalMap getMap(int pos) {
        return this.row.getMap(this.offset + pos);
    }

    public InternalRow getRow(int pos, int numFields) {
        return this.row.getRow(this.offset + pos, numFields);
    }
}

