/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.CatalogCredentialManager;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialPropertyUtils;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.ops.IcebergCatalogWrapper;
import org.apache.gravitino.utils.MapUtils;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ServiceUnavailableException;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.responses.LoadTableResponse;

public class CatalogWrapperForREST
extends IcebergCatalogWrapper {
    private final CatalogCredentialManager catalogCredentialManager;
    private final Map<String, String> catalogConfigToClients;
    private static final Set<String> catalogPropertiesToClientKeys = ImmutableSet.of((Object)"io-impl", (Object)"client.region", (Object)"s3.endpoint", (Object)"oss.endpoint");
    private static Map<String, String> deprecatedProperties = ImmutableMap.of((Object)"credential-provider-type", (Object)"credential-providers", (Object)"gcs-credential-file-path", (Object)"gcs-service-account-file");

    public CatalogWrapperForREST(String catalogName, IcebergConfig config) {
        super(config);
        this.catalogConfigToClients = MapUtils.getFilteredMap((Map)config.getIcebergCatalogProperties(), key -> catalogPropertiesToClientKeys.contains(key));
        Map<String, String> catalogProperties = CatalogWrapperForREST.checkForCompatibility(config.getAllConfig(), deprecatedProperties);
        this.catalogCredentialManager = new CatalogCredentialManager(catalogName, catalogProperties);
    }

    public LoadTableResponse createTable(Namespace namespace, CreateTableRequest request, boolean requestCredential) {
        LoadTableResponse loadTableResponse = super.createTable(namespace, request);
        if (requestCredential) {
            return this.injectCredentialConfig(TableIdentifier.of((Namespace)namespace, (String)request.name()), loadTableResponse);
        }
        return loadTableResponse;
    }

    public LoadTableResponse loadTable(TableIdentifier identifier, boolean requestCredential) {
        LoadTableResponse loadTableResponse = super.loadTable(identifier);
        if (requestCredential) {
            return this.injectCredentialConfig(identifier, loadTableResponse);
        }
        return loadTableResponse;
    }

    public void close() {
        if (this.catalogCredentialManager != null) {
            this.catalogCredentialManager.close();
        }
    }

    private Map<String, String> getCatalogConfigToClient() {
        return this.catalogConfigToClients;
    }

    private LoadTableResponse injectCredentialConfig(TableIdentifier tableIdentifier, LoadTableResponse loadTableResponse) {
        TableMetadata tableMetadata = loadTableResponse.tableMetadata();
        Object[] path = (String[])Stream.of(tableMetadata.location(), tableMetadata.property("write.data.path", ""), tableMetadata.property("write.metadata.path", "")).filter(StringUtils::isNotBlank).toArray(String[]::new);
        PathBasedCredentialContext context = new PathBasedCredentialContext(PrincipalUtils.getCurrentUserName(), (Set)ImmutableSet.copyOf((Object[])path), Collections.emptySet());
        Credential credential = this.catalogCredentialManager.getCredential((CredentialContext)context);
        if (credential == null) {
            throw new ServiceUnavailableException("Couldn't generate credential, %s", new Object[]{context});
        }
        LOG.info("Generate credential: {} for Iceberg table: {}", (Object)credential.credentialType(), (Object)tableIdentifier);
        Map credentialConfig = CredentialPropertyUtils.toIcebergProperties((Credential)credential);
        return LoadTableResponse.builder().withTableMetadata(loadTableResponse.tableMetadata()).addAllConfig(loadTableResponse.config()).addAllConfig(this.getCatalogConfigToClient()).addAllConfig(credentialConfig).build();
    }

    @VisibleForTesting
    static Map<String, String> checkForCompatibility(Map<String, String> properties, Map<String, String> deprecatedProperties) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        deprecatedProperties.forEach((deprecatedProperty, newProperty) -> CatalogWrapperForREST.replaceDeprecatedProperties(newProperties, deprecatedProperty, newProperty));
        return newProperties;
    }

    private static void replaceDeprecatedProperties(Map<String, String> properties, String deprecatedProperty, String newProperty) {
        String deprecatedValue = properties.get(deprecatedProperty);
        String newValue = properties.get(newProperty);
        if (StringUtils.isNotBlank((CharSequence)deprecatedValue) && StringUtils.isNotBlank((CharSequence)newValue)) {
            throw new IllegalArgumentException(String.format("Should not set both %s and %s", deprecatedProperty, newProperty));
        }
        if (StringUtils.isNotBlank((CharSequence)deprecatedValue)) {
            LOG.warn("%s is deprecated, please use %s instead.", (Object)deprecatedProperty, (Object)newProperty);
            properties.remove(deprecatedProperty);
            properties.put(newProperty, deprecatedValue);
        }
    }
}

