/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.authorization.OwnerDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class OwnerResponse
extends BaseResponse {
    @Nullable
    @JsonProperty(value="owner")
    private final OwnerDTO owner;

    public OwnerResponse(OwnerDTO owner) {
        super(0);
        this.owner = owner;
    }

    public OwnerResponse() {
        super(0);
        this.owner = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.owner != null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.owner.name()), (Object)"owner 'name' must not be null or empty");
            Preconditions.checkArgument((this.owner.type() != null ? 1 : 0) != 0, (Object)"owner 'type' must not be null");
        }
    }

    @Nullable
    public OwnerDTO getOwner() {
        return this.owner;
    }

    @Override
    public String toString() {
        return "OwnerResponse(owner=" + this.getOwner() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwnerResponse)) {
            return false;
        }
        OwnerResponse other = (OwnerResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OwnerDTO this$owner = this.getOwner();
        OwnerDTO other$owner = other.getOwner();
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OwnerResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OwnerDTO $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

