/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcSetting;
import org.apache.kerby.kerberos.kerb.server.KdcUtil;
import org.apache.kerby.kerberos.kerb.server.impl.AbstractInternalKdcServer;
import org.apache.kerby.kerberos.kerb.server.impl.DefaultKdcHandler;
import org.apache.kerby.kerberos.kerb.server.preauth.PreauthHandler;
import org.apache.kerby.kerberos.kerb.transport.KdcNetwork;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInternalKdcServerImpl
extends AbstractInternalKdcServer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInternalKdcServerImpl.class);
    private ExecutorService executor;
    private KdcContext kdcContext;
    private KdcNetwork network;

    public DefaultInternalKdcServerImpl(KdcSetting kdcSetting) {
        super(kdcSetting);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.prepareHandler();
        this.executor = Executors.newCachedThreadPool();
        this.network = new KdcNetwork(){

            protected void onNewTransport(KrbTransport transport) {
                DefaultKdcHandler kdcHandler = new DefaultKdcHandler(DefaultInternalKdcServerImpl.this.kdcContext, transport);
                DefaultInternalKdcServerImpl.this.executor.execute(kdcHandler);
            }
        };
        this.network.init();
        TransportPair tpair = KdcUtil.getTransportPair(this.getSetting());
        this.network.listen(tpair);
        this.network.start();
    }

    private void prepareHandler() {
        this.kdcContext = new KdcContext(this.getSetting());
        this.kdcContext.setIdentityService(this.getIdentityService());
        PreauthHandler preauthHandler = new PreauthHandler();
        preauthHandler.init();
        this.kdcContext.setPreauthHandler(preauthHandler);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.network != null) {
            this.network.stop();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                boolean terminated = false;
                while (!(terminated = this.executor.awaitTermination(60L, TimeUnit.SECONDS))) {
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                LOG.warn("waitForTermination interrupted");
            }
        }
        LOG.info("Default Internal kdc server stopped.");
    }
}

