/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions.transforms;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.Partitions;

@Evolving
public interface Transform
extends Expression {
    public String name();

    public Expression[] arguments();

    default public Partition[] assignments() {
        return Partitions.EMPTY_PARTITIONS;
    }

    @Override
    default public Expression[] children() {
        return this.arguments();
    }

    public static abstract class SingleFieldTransform
    implements Transform {
        NamedReference ref;

        public String[] fieldName() {
            return this.ref.fieldName();
        }

        @Override
        public NamedReference[] references() {
            return new NamedReference[]{this.ref};
        }

        @Override
        public Expression[] arguments() {
            return new Expression[]{this.ref};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SingleFieldTransform)) {
                return false;
            }
            SingleFieldTransform that = (SingleFieldTransform)o;
            return Objects.equals(this.ref, that.ref);
        }

        public int hashCode() {
            return Objects.hash(this.ref);
        }
    }
}

