/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.SpanReceiverInfoBuilder;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;
import org.apache.hadoop.tracing.TraceAdminProtocolTranslatorPB;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TraceAdmin
extends Configured
implements Tool {
    private TraceAdminProtocolPB proxy;
    private TraceAdminProtocolTranslatorPB remote;
    private static final Logger LOG = LoggerFactory.getLogger(TraceAdmin.class);
    private static final String CONFIG_PREFIX = "-C";

    private void usage() {
        PrintStream err = System.err;
        err.print("Hadoop tracing configuration commands:\n  -add [-class classname] [-Ckey=value] [-Ckey2=value2] ...\n    Add a span receiver with the provided class name.  Configuration\n    keys for the span receiver can be specified with the -C options.\n    The span receiver will also inherit whatever configuration keys\n    exist in the daemon's configuration.\n  -help: Print this help message.\n  -host [hostname:port]\n    Specify the hostname and port of the daemon to examine.\n    Required for all commands.\n  -list: List the current span receivers.\n  -remove [id]\n    Remove the span receiver with the specified id.  Use -list to\n    find the id of each receiver.\n  -principal: If the daemon is Kerberized, specify the service\n    principal name.");
    }

    private int listSpanReceivers(List<String> args) throws IOException {
        SpanReceiverInfo[] infos = this.remote.listSpanReceivers();
        if (infos.length == 0) {
            System.out.println("[no span receivers found]");
            return 0;
        }
        TableListing listing = new TableListing.Builder().addField("ID").addField("CLASS").showHeaders().build();
        for (SpanReceiverInfo info : infos) {
            listing.addRow("" + info.getId(), info.getClassName());
        }
        System.out.println(listing.toString());
        return 0;
    }

    private int addSpanReceiver(List<String> args) throws IOException {
        String className = StringUtils.popOptionWithArgument("-class", args);
        if (className == null) {
            System.err.println("You must specify the classname with -class.");
            return 1;
        }
        ByteArrayOutputStream configStream = new ByteArrayOutputStream();
        PrintStream configsOut = new PrintStream((OutputStream)configStream, false, "UTF-8");
        SpanReceiverInfoBuilder factory = new SpanReceiverInfoBuilder(className);
        String prefix = "";
        for (int i = 0; i < args.size(); ++i) {
            String str = args.get(i);
            if (!str.startsWith(CONFIG_PREFIX)) {
                System.err.println("Can't understand argument: " + str);
                return 1;
            }
            int equalsIndex = (str = str.substring(CONFIG_PREFIX.length())).indexOf("=");
            if (equalsIndex < 0) {
                System.err.println("Can't parse configuration argument " + str);
                System.err.println("Arguments must be in the form key=value");
                return 1;
            }
            String key = str.substring(0, equalsIndex);
            String value = str.substring(equalsIndex + 1);
            factory.addConfigurationPair(key, value);
            configsOut.print(prefix + key + " = " + value);
            prefix = ", ";
        }
        String configStreamStr = configStream.toString("UTF-8");
        try {
            long id = this.remote.addSpanReceiver(factory.build());
            System.out.println("Added trace span receiver " + id + " with configuration " + configStreamStr);
        }
        catch (IOException e) {
            System.out.println("addSpanReceiver error with configuration " + configStreamStr);
            throw e;
        }
        return 0;
    }

    private int removeSpanReceiver(List<String> args) throws IOException {
        String indexStr = StringUtils.popFirstNonOption(args);
        long id = -1L;
        try {
            id = Long.parseLong(indexStr);
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse ID string " + indexStr + ": " + e.getMessage());
            return 1;
        }
        this.remote.removeSpanReceiver(id);
        System.err.println("Removed trace span receiver " + id);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] argv) throws Exception {
        LinkedList<String> args = new LinkedList<String>();
        for (String arg : argv) {
            args.add(arg);
        }
        if (StringUtils.popOption("-h", args) || StringUtils.popOption("-help", args)) {
            this.usage();
            return 0;
        }
        if (args.size() == 0) {
            this.usage();
            return 0;
        }
        String hostPort = StringUtils.popOptionWithArgument("-host", args);
        if (hostPort == null) {
            System.err.println("You must specify a host with -host.");
            return 1;
        }
        if (args.isEmpty()) {
            System.err.println("You must specify an operation.");
            return 1;
        }
        String servicePrincipal = StringUtils.popOptionWithArgument("-principal", args);
        if (servicePrincipal != null) {
            LOG.debug("Set service principal: {}", (Object)servicePrincipal);
            this.getConf().set("hadoop.security.service.user.name.key", servicePrincipal);
        }
        RPC.setProtocolEngine(this.getConf(), TraceAdminProtocolPB.class, ProtobufRpcEngine2.class);
        InetSocketAddress address = NetUtils.createSocketAddr(hostPort);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Class<TraceAdminProtocolPB> xface = TraceAdminProtocolPB.class;
        this.proxy = RPC.getProxy(xface, RPC.getProtocolVersion(xface), address, ugi, this.getConf(), NetUtils.getDefaultSocketFactory(this.getConf()), 0);
        this.remote = new TraceAdminProtocolTranslatorPB(this.proxy);
        try {
            if (args.get(0).equals("-list")) {
                int n = this.listSpanReceivers(args.subList(1, args.size()));
                return n;
            }
            if (args.get(0).equals("-add")) {
                int n = this.addSpanReceiver(args.subList(1, args.size()));
                return n;
            }
            if (args.get(0).equals("-remove")) {
                int n = this.removeSpanReceiver(args.subList(1, args.size()));
                return n;
            }
            System.err.println("Unrecognized tracing command: " + args.get(0));
            System.err.println("Use -help for help.");
            int n = 1;
            return n;
        }
        finally {
            this.remote.close();
        }
    }

    public static void main(String[] argv) throws Exception {
        TraceAdmin admin = new TraceAdmin();
        admin.setConf(new Configuration());
        System.exit(admin.run(argv));
    }
}

