/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintFromProtoConverter;
import org.apache.hadoop.yarn.api.pb.PlacementConstraintToProtoConverter;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ExecutionTypeRequestPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceSizingPBImpl;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulingRequestPBImpl
extends SchedulingRequest {
    YarnProtos.SchedulingRequestProto proto = YarnProtos.SchedulingRequestProto.getDefaultInstance();
    YarnProtos.SchedulingRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Priority priority = null;
    private ExecutionTypeRequest executionType = null;
    private Set<String> allocationTags = null;
    private ResourceSizing resourceSizing = null;
    private PlacementConstraint placementConstraint = null;

    public SchedulingRequestPBImpl() {
        this.builder = YarnProtos.SchedulingRequestProto.newBuilder();
    }

    public SchedulingRequestPBImpl(YarnProtos.SchedulingRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.SchedulingRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.priority != null) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.executionType != null) {
            this.builder.setExecutionType(this.convertToProtoFormat(this.executionType));
        }
        if (this.allocationTags != null) {
            this.builder.clearAllocationTags();
            this.builder.addAllAllocationTags(this.allocationTags);
        }
        if (this.resourceSizing != null) {
            this.builder.setResourceSizing(this.convertToProtoFormat(this.resourceSizing));
        }
        if (this.placementConstraint != null) {
            this.builder.setPlacementConstraint(this.convertToProtoFormat(this.placementConstraint));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.SchedulingRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public long getAllocationRequestId() {
        YarnProtos.SchedulingRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getAllocationRequestId();
    }

    @Override
    public void setAllocationRequestId(long allocationRequestId) {
        this.maybeInitBuilder();
        this.builder.setAllocationRequestId(allocationRequestId);
    }

    @Override
    public Priority getPriority() {
        YarnProtos.SchedulingRequestProtoOrBuilder p;
        YarnProtos.SchedulingRequestProtoOrBuilder schedulingRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public ExecutionTypeRequest getExecutionType() {
        YarnProtos.SchedulingRequestProtoOrBuilder p;
        YarnProtos.SchedulingRequestProtoOrBuilder schedulingRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.executionType != null) {
            return this.executionType;
        }
        if (!p.hasExecutionType()) {
            return null;
        }
        this.executionType = this.convertFromProtoFormat(p.getExecutionType());
        return this.executionType;
    }

    @Override
    public void setExecutionType(ExecutionTypeRequest executionType) {
        this.maybeInitBuilder();
        if (executionType == null) {
            this.builder.clearExecutionType();
        }
        this.executionType = executionType;
    }

    @Override
    public Set<String> getAllocationTags() {
        this.initAllocationTags();
        return this.allocationTags;
    }

    @Override
    public void setAllocationTags(Set<String> allocationTags) {
        this.maybeInitBuilder();
        this.builder.clearAllocationTags();
        this.allocationTags = allocationTags;
    }

    @Override
    public ResourceSizing getResourceSizing() {
        YarnProtos.SchedulingRequestProtoOrBuilder p;
        YarnProtos.SchedulingRequestProtoOrBuilder schedulingRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resourceSizing != null) {
            return this.resourceSizing;
        }
        if (!p.hasResourceSizing()) {
            return null;
        }
        this.resourceSizing = this.convertFromProtoFormat(p.getResourceSizing());
        return this.resourceSizing;
    }

    @Override
    public void setResourceSizing(ResourceSizing resourceSizing) {
        this.maybeInitBuilder();
        if (resourceSizing == null) {
            this.builder.clearResourceSizing();
        }
        this.resourceSizing = resourceSizing;
    }

    @Override
    public PlacementConstraint getPlacementConstraint() {
        YarnProtos.SchedulingRequestProtoOrBuilder p;
        YarnProtos.SchedulingRequestProtoOrBuilder schedulingRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.placementConstraint != null) {
            return this.placementConstraint;
        }
        if (!p.hasPlacementConstraint()) {
            return null;
        }
        this.placementConstraint = this.convertFromProtoFormat(p.getPlacementConstraint());
        return this.placementConstraint;
    }

    @Override
    public void setPlacementConstraint(PlacementConstraint placementConstraint) {
        this.maybeInitBuilder();
        if (placementConstraint == null) {
            this.builder.clearPlacementConstraint();
        }
        this.placementConstraint = placementConstraint;
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority p) {
        return ((PriorityPBImpl)p).getProto();
    }

    private ExecutionTypeRequestPBImpl convertFromProtoFormat(YarnProtos.ExecutionTypeRequestProto p) {
        return new ExecutionTypeRequestPBImpl(p);
    }

    private YarnProtos.ExecutionTypeRequestProto convertToProtoFormat(ExecutionTypeRequest p) {
        return ((ExecutionTypeRequestPBImpl)p).getProto();
    }

    private ResourceSizingPBImpl convertFromProtoFormat(YarnProtos.ResourceSizingProto p) {
        return new ResourceSizingPBImpl(p);
    }

    private YarnProtos.ResourceSizingProto convertToProtoFormat(ResourceSizing p) {
        return ((ResourceSizingPBImpl)p).getProto();
    }

    private PlacementConstraint convertFromProtoFormat(YarnProtos.PlacementConstraintProto c) {
        PlacementConstraintFromProtoConverter fromProtoConverter = new PlacementConstraintFromProtoConverter(c);
        return fromProtoConverter.convert();
    }

    private YarnProtos.PlacementConstraintProto convertToProtoFormat(PlacementConstraint c) {
        PlacementConstraintToProtoConverter toProtoConverter = new PlacementConstraintToProtoConverter(c);
        return toProtoConverter.convert();
    }

    private void initAllocationTags() {
        if (this.allocationTags != null) {
            return;
        }
        YarnProtos.SchedulingRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.allocationTags = new HashSet<String>();
        this.allocationTags.addAll(p.getAllocationTagsList());
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SchedulingRequest) {
            if (this == other) {
                return true;
            }
            SchedulingRequest that = (SchedulingRequest)other;
            if (this.getAllocationRequestId() != that.getAllocationRequestId()) {
                return false;
            }
            if (!this.getAllocationTags().equals(that.getAllocationTags())) {
                return false;
            }
            if (!this.getPriority().equals(that.getPriority())) {
                return false;
            }
            if (!this.getExecutionType().equals(that.getExecutionType())) {
                return false;
            }
            if (!this.getResourceSizing().equals(that.getResourceSizing())) {
                return false;
            }
            return this.getPlacementConstraint().equals(that.getPlacementConstraint());
        }
        return false;
    }

    public String toString() {
        return "SchedulingRequestPBImpl{priority=" + this.getPriority() + ", allocationReqId=" + this.getAllocationRequestId() + ", executionType=" + this.getExecutionType() + ", allocationTags=" + this.getAllocationTags() + ", resourceSizing=" + this.getResourceSizing() + ", placementConstraint=" + this.getPlacementConstraint() + '}';
    }
}

