/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FileCleanupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FileCleanupStrategy.class);
    protected final FileIO fileIO;
    protected final ExecutorService planExecutorService;
    private final Consumer<String> deleteFunc;
    private final ExecutorService deleteExecutorService;
    private static final Schema MANIFEST_PROJECTION = ManifestFile.schema().select(new String[]{"manifest_path", "manifest_length", "partition_spec_id", "added_snapshot_id", "deleted_data_files_count"});

    protected FileCleanupStrategy(FileIO fileIO, ExecutorService deleteExecutorService, ExecutorService planExecutorService, Consumer<String> deleteFunc) {
        this.fileIO = fileIO;
        this.deleteExecutorService = deleteExecutorService;
        this.planExecutorService = planExecutorService;
        this.deleteFunc = deleteFunc;
    }

    public abstract void cleanFiles(TableMetadata var1, TableMetadata var2);

    protected CloseableIterable<ManifestFile> readManifests(Snapshot snapshot) {
        if (snapshot.manifestListLocation() != null) {
            return Avro.read(this.fileIO.newInputFile(snapshot.manifestListLocation())).rename("manifest_file", GenericManifestFile.class.getName()).classLoader(GenericManifestFile.class.getClassLoader()).project(MANIFEST_PROJECTION).reuseContainers(true).build();
        }
        return CloseableIterable.withNoopClose((Iterable)snapshot.allManifests(this.fileIO));
    }

    protected void deleteFiles(Set<String> pathsToDelete, String fileType) {
        Tasks.foreach(pathsToDelete).executeWith(this.deleteExecutorService).retry(3).stopRetryOn(NotFoundException.class).suppressFailureWhenFinished().onFailure((file, thrown) -> LOG.warn("Delete failed for {} file: {}", new Object[]{fileType, file, thrown})).run(this.deleteFunc::accept);
    }

    protected boolean hasAnyStatisticsFiles(TableMetadata tableMetadata) {
        return !tableMetadata.statisticsFiles().isEmpty() || !tableMetadata.partitionStatisticsFiles().isEmpty();
    }

    protected Set<String> expiredStatisticsFilesLocations(TableMetadata beforeExpiration, TableMetadata afterExpiration) {
        Set<String> statsFileLocationsBeforeExpiration = this.statsFileLocations(beforeExpiration);
        Set<String> statsFileLocationsAfterExpiration = this.statsFileLocations(afterExpiration);
        return Sets.difference(statsFileLocationsBeforeExpiration, statsFileLocationsAfterExpiration);
    }

    private Set<String> statsFileLocations(TableMetadata tableMetadata) {
        HashSet statsFileLocations = Sets.newHashSet();
        if (tableMetadata.statisticsFiles() != null) {
            tableMetadata.statisticsFiles().stream().map(StatisticsFile::path).forEach(statsFileLocations::add);
        }
        if (tableMetadata.partitionStatisticsFiles() != null) {
            tableMetadata.partitionStatisticsFiles().stream().map(PartitionStatisticsFile::path).forEach(statsFileLocations::add);
        }
        return statsFileLocations;
    }
}

