/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.common;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.authorization.common.ChainedAuthorizationProperties;
import org.apache.gravitino.authorization.common.RangerAuthorizationProperties;

public abstract class AuthorizationProperties {
    protected Map<String, String> properties;

    public AuthorizationProperties(Map<String, String> properties) {
        this.properties = properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.getPropertiesPrefix())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public abstract String getPropertiesPrefix();

    public abstract void validate();

    public static void validate(String type, Map<String, String> properties) {
        switch (type) {
            case "ranger": {
                RangerAuthorizationProperties rangerAuthorizationProperties = new RangerAuthorizationProperties(properties);
                rangerAuthorizationProperties.validate();
                break;
            }
            case "chain": {
                ChainedAuthorizationProperties chainedAuthzProperties = new ChainedAuthorizationProperties(properties);
                chainedAuthzProperties.validate();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authorization properties type: " + type);
            }
        }
    }
}

