/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos.FetchFileUtils;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos.KerberosConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosClient.class);
    public static final String GRAVITINO_KEYTAB_FORMAT = "keytabs/gravitino-lakehouse-paimon-%s-keytab";
    private final ScheduledThreadPoolExecutor checkTgtExecutor;
    private final Map<String, String> conf;
    private final Configuration hadoopConf;

    public KerberosClient(Map<String, String> conf, Configuration hadoopConf) {
        this.conf = conf;
        this.hadoopConf = hadoopConf;
        this.checkTgtExecutor = new ScheduledThreadPoolExecutor(1, KerberosClient.getThreadFactory("check-tgt"));
    }

    public void login(String keytabFilePath) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf);
        String catalogPrincipal = kerberosConfig.getPrincipalName();
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
        UserGroupInformation.loginUserFromKeytab((String)catalogPrincipal, (String)keytabFilePath);
        UserGroupInformation kerberosLoginUgi = UserGroupInformation.getCurrentUser();
        int checkInterval = kerberosConfig.getCheckIntervalSec();
        this.checkTgtExecutor.scheduleAtFixedRate(() -> {
            try {
                kerberosLoginUgi.checkTGTAndReloginFromKeytab();
            }
            catch (Exception e) {
                LOG.error("Fail to refresh ugi token: ", (Throwable)e);
            }
        }, checkInterval, checkInterval, TimeUnit.SECONDS);
    }

    public File saveKeyTabFileFromUri(String catalogId) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf);
        String keyTabUri = kerberosConfig.getKeytab();
        File keytabsDir = new File("keytabs");
        if (!keytabsDir.exists()) {
            keytabsDir.mkdir();
        }
        File keytabFile = new File(String.format(GRAVITINO_KEYTAB_FORMAT, catalogId));
        keytabFile.deleteOnExit();
        if (keytabFile.exists() && !keytabFile.delete()) {
            throw new IllegalStateException(String.format("Fail to delete keytab file %s", keytabFile.getAbsolutePath()));
        }
        int fetchKeytabFileTimeout = kerberosConfig.getFetchTimeoutSec();
        FetchFileUtils.fetchFileFromUri(keyTabUri, keytabFile, fetchKeytabFileTimeout);
        return keytabFile;
    }

    private static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }

    @Override
    public void close() {
        if (this.checkTgtExecutor != null) {
            this.checkTgtExecutor.shutdown();
        }
    }
}

