/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.operation;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTablePartitionOperations;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public interface TableOperation {
    public void initialize(DataSource var1, JdbcExceptionConverter var2, JdbcTypeConverter var3, JdbcColumnDefaultValueConverter var4, Map<String, String> var5);

    public void create(String var1, String var2, JdbcColumn[] var3, String var4, Map<String, String> var5, Transform[] var6, Distribution var7, Index[] var8) throws TableAlreadyExistsException;

    public boolean drop(String var1, String var2);

    public List<String> listTables(String var1) throws NoSuchSchemaException;

    public JdbcTable load(String var1, String var2) throws NoSuchTableException;

    public void rename(String var1, String var2, String var3) throws NoSuchTableException;

    public void alterTable(String var1, String var2, TableChange ... var3) throws NoSuchTableException;

    public boolean purge(String var1, String var2);

    default public JdbcTablePartitionOperations createJdbcTablePartitionOperations(JdbcTable loadedTable) {
        throw new UnsupportedOperationException("Table partition operation is not supported yet");
    }
}

