/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.kerby.config.Config;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.kerby.kerberos.kerb.identity.backend.MemoryIdentityBackend;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.kerberos.kerb.server.KdcConfigKey;
import org.apache.kerby.kerberos.kerb.server.KdcSetting;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;

public final class KdcUtil {
    private KdcUtil() {
    }

    public static KdcConfig getKdcConfig(File confDir) throws KrbException {
        File kdcConfFile = new File(confDir, "kdc.conf");
        if (kdcConfFile.exists()) {
            KdcConfig kdcConfig = new KdcConfig();
            try {
                kdcConfig.addKrb5Config(kdcConfFile);
            }
            catch (IOException e) {
                throw new KrbException("Can not load the kdc configuration file " + kdcConfFile.getAbsolutePath());
            }
            return kdcConfig;
        }
        return null;
    }

    public static BackendConfig getBackendConfig(File confDir) throws KrbException {
        File backendConfigFile = new File(confDir, "backend.conf");
        if (backendConfigFile.exists()) {
            BackendConfig backendConfig = new BackendConfig();
            try {
                backendConfig.addIniConfig(backendConfigFile);
            }
            catch (IOException e) {
                throw new KrbException("Can not load the backend configuration file " + backendConfigFile.getAbsolutePath());
            }
            return backendConfig;
        }
        return null;
    }

    public static IdentityBackend getBackend(BackendConfig backendConfig) throws KrbException {
        IdentityBackend backend;
        Class<?> backendClass;
        String backendClassName = backendConfig.getString((ConfigKey)KdcConfigKey.KDC_IDENTITY_BACKEND, true);
        if (backendClassName == null) {
            backendClassName = MemoryIdentityBackend.class.getCanonicalName();
        }
        try {
            backendClass = Class.forName(backendClassName);
        }
        catch (ClassNotFoundException e) {
            throw new KrbException("Failed to load backend class: " + backendClassName);
        }
        try {
            backend = (IdentityBackend)backendClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KrbException("Failed to create backend: " + backendClassName);
        }
        backend.setConfig((Config)backendConfig);
        backend.initialize();
        return backend;
    }

    public static TransportPair getTransportPair(KdcSetting setting) throws KrbException {
        int udpPort;
        TransportPair result = new TransportPair();
        int tcpPort = setting.checkGetKdcTcpPort();
        if (tcpPort > 0) {
            result.tcpAddress = new InetSocketAddress(setting.getKdcHost(), tcpPort);
        }
        if ((udpPort = setting.checkGetKdcUdpPort()) > 0) {
            result.udpAddress = new InetSocketAddress(setting.getKdcHost(), udpPort);
        }
        return result;
    }
}

