/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.dto.requests.ModelRegisterRequest;
import org.apache.gravitino.dto.requests.ModelVersionLinkRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.ModelResponse;
import org.apache.gravitino.dto.responses.ModelVersionListResponse;
import org.apache.gravitino.dto.responses.ModelVersionResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/catalogs/{catalog}/schemas/{schema}/models")
public class ModelOperations {
    private static final Logger LOG = LoggerFactory.getLogger(ModelOperations.class);
    private final ModelDispatcher modelDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public ModelOperations(ModelDispatcher modelDispatcher) {
        this.modelDispatcher = modelDispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-model", absolute=true)
    public Response listModels(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema) {
        LOG.info("Received list models request for schema: {}.{}.{}", new Object[]{metalake, catalog, schema});
        Namespace modelNs = NamespaceUtil.ofModel((String)metalake, (String)catalog, (String)schema);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier[] modelIds = this.modelDispatcher.listModels(modelNs);
                modelIds = modelIds == null ? new NameIdentifier[]{} : modelIds;
                LOG.info("List {} models under schema {}", (Object)modelIds.length, (Object)modelNs);
                return Utils.ok(new EntityListResponse(modelIds));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.LIST, "", schema, e);
        }
    }

    @GET
    @Path(value="{model}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model", absolute=true)
    public Response getModel(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model) {
        LOG.info("Received get model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                Model m = this.modelDispatcher.getModel(modelId);
                LOG.info("Model got: {}", (Object)modelId);
                return Utils.ok(new ModelResponse(DTOConverters.toDTO((Model)m)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, model, schema, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="register-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-model", absolute=true)
    public Response registerModel(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, ModelRegisterRequest request) {
        LOG.info("Received register model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, request.getName()});
        try {
            request.validate();
            NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)request.getName());
            return Utils.doAs(this.httpRequest, () -> {
                Model m = this.modelDispatcher.registerModel(modelId, request.getComment(), request.getProperties());
                LOG.info("Model registered: {}", (Object)modelId);
                return Utils.ok(new ModelResponse(DTOConverters.toDTO((Model)m)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.REGISTER, request.getName(), schema, e);
        }
    }

    @DELETE
    @Path(value="{model}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-model.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-model", absolute=true)
    public Response deleteModel(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model) {
        LOG.info("Received delete model request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                boolean deleted = this.modelDispatcher.deleteModel(modelId);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted model {} under schema {}", (Object)model, (Object)schema);
                } else {
                    LOG.info("Model deleted: {}", (Object)modelId);
                }
                return Utils.ok(new DropResponse(deleted));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.DELETE, model, schema, e);
        }
    }

    @GET
    @Path(value="{model}/versions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-model-versions.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-model-versions", absolute=true)
    public Response listModelVersions(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model) {
        LOG.info("Received list model versions request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                int[] versions = this.modelDispatcher.listModelVersions(modelId);
                versions = versions == null ? new int[]{} : versions;
                LOG.info("List {} versions of model {}", (Object)versions.length, (Object)modelId);
                return Utils.ok(new ModelVersionListResponse(versions));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.LIST_VERSIONS, model, schema, e);
        }
    }

    @GET
    @Path(value="{model}/versions/{version}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model-version", absolute=true)
    public Response getModelVersion(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model, @PathParam(value="version") int version) {
        LOG.info("Received get model version request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, version});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                ModelVersion mv = this.modelDispatcher.getModelVersion(modelId, version);
                LOG.info("Model version got: {}.{}", (Object)modelId, (Object)version);
                return Utils.ok(new ModelVersionResponse(DTOConverters.toDTO((ModelVersion)mv)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, this.versionString(model, version), schema, e);
        }
    }

    @GET
    @Path(value="{model}/aliases/{alias}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-model-alias.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-model-alias", absolute=true)
    public Response getModelVersionByAlias(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model, @PathParam(value="alias") String alias) {
        LOG.info("Received get model version alias request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, alias});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                ModelVersion mv = this.modelDispatcher.getModelVersion(modelId, alias);
                LOG.info("Model version alias got: {}.{}", (Object)modelId, (Object)alias);
                return Utils.ok(new ModelVersionResponse(DTOConverters.toDTO((ModelVersion)mv)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.GET, this.aliasString(model, alias), schema, e);
        }
    }

    @POST
    @Path(value="{model}/versions")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="link-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="link-model-version", absolute=true)
    public Response linkModelVersion(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model, ModelVersionLinkRequest request) {
        LOG.info("Received link model version request: {}.{}.{}.{}", new Object[]{metalake, catalog, schema, model});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            request.validate();
            return Utils.doAs(this.httpRequest, () -> {
                this.modelDispatcher.linkModelVersion(modelId, request.getUri(), request.getAliases(), request.getComment(), request.getProperties());
                LOG.info("Model version linked: {}", (Object)modelId);
                return Utils.ok(new BaseResponse());
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.LINK, model, schema, e);
        }
    }

    @DELETE
    @Path(value="{model}/versions/{version}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-model-version.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-model-version", absolute=true)
    public Response deleteModelVersion(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model, @PathParam(value="version") int version) {
        LOG.info("Received delete model version request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, version});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                boolean deleted = this.modelDispatcher.deleteModelVersion(modelId, version);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted version {} in model {}", (Object)version, (Object)model);
                } else {
                    LOG.info("Model version deleted: {}.{}", (Object)modelId, (Object)version);
                }
                return Utils.ok(new DropResponse(deleted));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.DELETE, this.versionString(model, version), schema, e);
        }
    }

    @DELETE
    @Path(value="{model}/aliases/{alias}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-model-alias.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-model-alias", absolute=true)
    public Response deleteModelVersionByAlias(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="model") String model, @PathParam(value="alias") String alias) {
        LOG.info("Received delete model version by alias request: {}.{}.{}.{}.{}", new Object[]{metalake, catalog, schema, model, alias});
        NameIdentifier modelId = NameIdentifierUtil.ofModel((String)metalake, (String)catalog, (String)schema, (String)model);
        try {
            return Utils.doAs(this.httpRequest, () -> {
                boolean deleted = this.modelDispatcher.deleteModelVersion(modelId, alias);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted model version by alias {} in model {}", (Object)alias, (Object)model);
                } else {
                    LOG.info("Model version by alias deleted: {}.{}", (Object)modelId, (Object)alias);
                }
                return Utils.ok(new DropResponse(deleted));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleModelException(OperationType.DELETE, this.aliasString(model, alias), schema, e);
        }
    }

    private String versionString(String model, int version) {
        return model + " version(" + version + ")";
    }

    private String aliasString(String model, String alias) {
        return model + " alias(" + alias + ")";
    }
}

