/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen.codesplit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.paimon.codegen.codesplit.CodeRewriter;
import org.apache.paimon.codegen.codesplit.CodeSplitUtil;
import org.apache.paimon.codegen.codesplit.JavaLexer;
import org.apache.paimon.codegen.codesplit.JavaParser;
import org.apache.paimon.codegen.codesplit.JavaParserBaseVisitor;
import org.apache.paimon.shade.org.antlr.v4.runtime.CharStreams;
import org.apache.paimon.shade.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.paimon.shade.org.antlr.v4.runtime.Token;
import org.apache.paimon.shade.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.paimon.utils.Preconditions;

public class DeclarationRewriter
implements CodeRewriter {
    private final String code;
    private final int maxMethodLength;
    private final CommonTokenStream tokenStream;
    private final TokenStreamRewriter rewriter;
    private boolean hasRewrite = false;

    public DeclarationRewriter(String code, int maxMethodLength) {
        this.code = code;
        this.maxMethodLength = maxMethodLength;
        this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(code)));
        this.rewriter = new TokenStreamRewriter(this.tokenStream);
    }

    @Override
    public String rewrite() {
        JavaParser javaParser = new JavaParser(this.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        new OuterBlockStatementExtractor().visit(javaParser.compilationUnit());
        String text = this.rewriter.getText();
        return this.hasRewrite ? text : null;
    }

    private class OuterBlockStatementExtractor
    extends JavaParserBaseVisitor<Void> {
        private final Stack<StringBuilder> newFields = new Stack();
        private final Set<String> allVarNames = new HashSet<String>();

        OuterBlockStatementExtractor() {
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            this.newFields.push(new StringBuilder());
            Void ret = (Void)this.visitChildren(ctx);
            DeclarationRewriter.this.rewriter.insertAfter(ctx.start, (Object)("\n" + this.newFields.pop().toString()));
            return ret;
        }

        @Override
        public Void visitFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
            if (ctx.variableDeclarators() != null) {
                for (JavaParser.VariableDeclaratorContext dec : ctx.variableDeclarators().variableDeclarator()) {
                    this.allVarNames.add(dec.variableDeclaratorId().getText());
                }
            }
            return (Void)this.visitChildren(ctx);
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if ("void".equals(ctx.typeTypeOrVoid().getText())) {
                this.visitMethodBody(ctx.methodBody());
            }
            return null;
        }

        @Override
        public Void visitMethodBody(JavaParser.MethodBodyContext ctx) {
            if (CodeSplitUtil.getContextTextLength(ctx.block()) <= DeclarationRewriter.this.maxMethodLength) {
                return null;
            }
            DeclarationRewriter.this.hasRewrite = true;
            InnerBlockStatementExtractor extractor = new InnerBlockStatementExtractor();
            if (ctx.block() != null && ctx.block().blockStatement() != null) {
                for (JavaParser.BlockStatementContext blockStatementContext : ctx.block().blockStatement()) {
                    extractor.visitBlockStatement(blockStatementContext);
                }
                this.newFields.peek().append(extractor.getNewLocalVariables());
            }
            return null;
        }

        private class InnerBlockStatementExtractor
        extends JavaParserBaseVisitor<Void> {
            private final StringBuilder newLocalVariables = new StringBuilder();
            private final Map<String, String> replaceMap = new HashMap<String, String>();

            InnerBlockStatementExtractor() {
            }

            @Override
            public Void visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
                Preconditions.checkArgument(ctx.variableDeclarators().variableDeclarator().size() == 1, "%s\nCodegen rewrite failed. You can only declare one local variable in one statement.", DeclarationRewriter.this.code);
                JavaParser.VariableDeclaratorContext dec = ctx.variableDeclarators().variableDeclarator(0);
                JavaParser.VariableDeclaratorIdContext decId = dec.variableDeclaratorId();
                this.extractLocalVariable(decId, ctx.typeType(), false);
                if (dec.variableInitializer() == null) {
                    DeclarationRewriter.this.rewriter.delete(ctx.start, ctx.getParent().stop);
                    return null;
                }
                if (ctx.variableModifier() != null) {
                    for (JavaParser.VariableModifierContext modifier : ctx.variableModifier()) {
                        DeclarationRewriter.this.rewriter.delete(modifier.start, modifier.stop);
                    }
                }
                DeclarationRewriter.this.rewriter.delete(ctx.typeType().start, ctx.typeType().stop);
                this.replaceLocalVar(decId.getText(), decId.IDENTIFIER().getSymbol());
                return (Void)this.visitChildren(ctx);
            }

            @Override
            public Void visitEnhancedForControl(JavaParser.EnhancedForControlContext ctx) {
                JavaParser.VariableDeclaratorIdContext decId = ctx.variableDeclaratorId();
                String newName = this.extractLocalVariable(decId, ctx.typeType(), true);
                JavaParser.StatementContext stmt = (JavaParser.StatementContext)ctx.getParent().getParent();
                Preconditions.checkState(stmt.statement(0) != null && stmt.statement(0).block() != null, "%s\nCodegen rewrite failed. For statements must be placed inside a block.\n", DeclarationRewriter.this.code);
                DeclarationRewriter.this.rewriter.insertAfter(stmt.statement((int)0).block().start, (Object)(newName + " = " + decId.getText() + ";"));
                return (Void)this.visitChildren(ctx);
            }

            private String extractLocalVariable(JavaParser.VariableDeclaratorIdContext decId, JavaParser.TypeTypeContext typeType, boolean forceNewName) {
                String name = decId.getText();
                if (forceNewName || OuterBlockStatementExtractor.this.allVarNames.contains(name)) {
                    String newName = CodeSplitUtil.newName("local");
                    this.replaceMap.put(name, newName);
                    this.newLocalVariables.append(typeType.getText()).append(" ").append(newName).append(";\n");
                    return newName;
                }
                this.newLocalVariables.append(typeType.getText()).append(" ").append(name).append(";\n");
                OuterBlockStatementExtractor.this.allVarNames.add(name);
                return name;
            }

            @Override
            public Void visitPrimary(JavaParser.PrimaryContext ctx) {
                if (ctx.IDENTIFIER() != null) {
                    this.replaceLocalVar(ctx.IDENTIFIER().getText(), ctx.IDENTIFIER().getSymbol());
                    return null;
                }
                return (Void)this.visitChildren(ctx);
            }

            private void replaceLocalVar(String name, Token token) {
                String rep = this.replaceMap.get(name);
                if (rep != null) {
                    DeclarationRewriter.this.rewriter.replace(token, (Object)rep);
                }
            }

            String getNewLocalVariables() {
                return this.newLocalVariables.toString();
            }
        }
    }
}

