/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import javax.annotation.Nullable;
import org.apache.paimon.compression.AirCompressorFactory;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.compression.Lz4BlockCompressionFactory;
import org.apache.paimon.shade.io.airlift.compress.Compressor;
import org.apache.paimon.shade.io.airlift.compress.Decompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoCompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoDecompressor;
import org.apache.paimon.shade.io.airlift.compress.zstd.ZstdCompressor;
import org.apache.paimon.shade.io.airlift.compress.zstd.ZstdDecompressor;

public interface BlockCompressionFactory {
    public BlockCompressor getCompressor();

    public BlockDecompressor getDecompressor();

    @Nullable
    public static BlockCompressionFactory create(String compression) {
        switch (compression.toUpperCase()) {
            case "NONE": {
                return null;
            }
            case "LZ4": {
                return new Lz4BlockCompressionFactory();
            }
            case "LZO": {
                return new AirCompressorFactory((Compressor)new LzoCompressor(), (Decompressor)new LzoDecompressor());
            }
            case "ZSTD": {
                return new AirCompressorFactory((Compressor)new ZstdCompressor(), (Decompressor)new ZstdDecompressor());
            }
        }
        throw new IllegalStateException("Unknown CompressionMethod " + compression);
    }
}

