/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinarySection;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.utils.Preconditions;

@Public
public final class BinaryString
extends BinarySection
implements Comparable<BinaryString> {
    private static final long serialVersionUID = 1L;
    public static final BinaryString EMPTY_UTF8 = BinaryString.fromBytes(BinaryString.encodeUTF8(""));
    private static final int MAX_BYTES_PER_CHAR = 3;

    public BinaryString(MemorySegment[] segments, int offset, int sizeInBytes) {
        super(segments, offset, sizeInBytes);
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    public static BinaryString fromAddress(MemorySegment[] segments, int offset, int numBytes) {
        return new BinaryString(segments, offset, numBytes);
    }

    @Nullable
    public static BinaryString fromString(String str) {
        if (str == null) {
            return null;
        }
        return BinaryString.fromBytes(BinaryString.encodeUTF8(str));
    }

    public static BinaryString fromBytes(byte[] bytes) {
        return BinaryString.fromBytes(bytes, 0, bytes.length);
    }

    public static BinaryString fromBytes(byte[] bytes, int offset, int numBytes) {
        return new BinaryString(new MemorySegment[]{MemorySegment.wrap(bytes)}, offset, numBytes);
    }

    public static BinaryString blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return BinaryString.fromBytes(spaces);
    }

    public String toString() {
        byte[] bytes = MemorySegmentUtils.allocateReuseBytes(this.sizeInBytes);
        MemorySegmentUtils.copyToBytes(this.segments, this.offset, bytes, 0, this.sizeInBytes);
        return BinaryString.decodeUTF8(bytes, 0, this.sizeInBytes);
    }

    @Override
    public int compareTo(@Nonnull BinaryString other) {
        if (this.segments.length == 1 && other.segments.length == 1) {
            int len = Math.min(this.sizeInBytes, other.sizeInBytes);
            MemorySegment seg1 = this.segments[0];
            MemorySegment seg2 = other.segments[0];
            for (int i = 0; i < len; ++i) {
                int res = (seg1.get(this.offset + i) & 0xFF) - (seg2.get(other.offset + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            return this.sizeInBytes - other.sizeInBytes;
        }
        return this.compareMultiSegments(other);
    }

    private int compareMultiSegments(BinaryString other) {
        int sizeOfFirst1;
        if (this.sizeInBytes == 0 || other.sizeInBytes == 0) {
            return this.sizeInBytes - other.sizeInBytes;
        }
        int len = Math.min(this.sizeInBytes, other.sizeInBytes);
        MemorySegment seg1 = this.segments[0];
        MemorySegment seg2 = other.segments[0];
        int segmentSize = this.segments[0].size();
        int otherSegmentSize = other.segments[0].size();
        int sizeOfFirst2 = otherSegmentSize - other.offset;
        int varSegIndex1 = 1;
        int varSegIndex2 = 1;
        for (sizeOfFirst1 = segmentSize - this.offset; sizeOfFirst1 <= 0; sizeOfFirst1 += segmentSize) {
            seg1 = this.segments[varSegIndex1++];
        }
        while (sizeOfFirst2 <= 0) {
            sizeOfFirst2 += otherSegmentSize;
            seg2 = other.segments[varSegIndex2++];
        }
        int offset1 = segmentSize - sizeOfFirst1;
        int offset2 = otherSegmentSize - sizeOfFirst2;
        int needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        while (needCompare > 0) {
            for (int i = 0; i < needCompare; ++i) {
                int res = (seg1.get(offset1 + i) & 0xFF) - (seg2.get(offset2 + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            if (needCompare == len) break;
            len -= needCompare;
            if (sizeOfFirst1 < sizeOfFirst2) {
                seg1 = this.segments[varSegIndex1++];
                offset1 = 0;
                offset2 += needCompare;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 -= needCompare;
            } else if (sizeOfFirst1 > sizeOfFirst2) {
                seg2 = other.segments[varSegIndex2++];
                offset2 = 0;
                offset1 += needCompare;
                sizeOfFirst2 = otherSegmentSize;
                sizeOfFirst1 -= needCompare;
            } else {
                seg1 = this.segments[varSegIndex1++];
                seg2 = other.segments[varSegIndex2++];
                offset1 = 0;
                offset2 = 0;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 = otherSegmentSize;
            }
            needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        }
        Preconditions.checkArgument(needCompare == len);
        return this.sizeInBytes - other.sizeInBytes;
    }

    public int numChars() {
        if (this.inFirstSegment()) {
            int len = 0;
            for (int i = 0; i < this.sizeInBytes; i += BinaryString.numBytesForFirstByte(this.getByteOneSegment(i))) {
                ++len;
            }
            return len;
        }
        return this.numCharsMultiSegs();
    }

    private int numCharsMultiSegs() {
        int len = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        while (i < this.sizeInBytes) {
            int charBytes = BinaryString.numBytesForFirstByte(index.value());
            i += charBytes;
            ++len;
            index.skipBytes(charBytes, segSize);
        }
        return len;
    }

    public byte byteAt(int index) {
        int globalOffset = this.offset + index;
        int size = this.segments[0].size();
        if (globalOffset < size) {
            return this.segments[0].get(globalOffset);
        }
        return this.segments[globalOffset / size].get(globalOffset % size);
    }

    public BinaryString copy() {
        byte[] copy = MemorySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        return BinaryString.fromBytes(copy);
    }

    public BinaryString substring(int beginIndex, int endIndex) {
        if (endIndex <= beginIndex || beginIndex >= this.sizeInBytes) {
            return EMPTY_UTF8;
        }
        if (this.inFirstSegment()) {
            int c;
            MemorySegment segment = this.segments[0];
            int i = 0;
            for (c = 0; i < this.sizeInBytes && c < beginIndex; i += BinaryString.numBytesForFirstByte(segment.get(i + this.offset)), ++c) {
            }
            int j = i;
            while (i < this.sizeInBytes && c < endIndex) {
                i += BinaryString.numBytesForFirstByte(segment.get(i + this.offset));
                ++c;
            }
            if (i > j) {
                byte[] bytes = new byte[i - j];
                segment.get(this.offset + j, bytes, 0, i - j);
                return BinaryString.fromBytes(bytes);
            }
            return EMPTY_UTF8;
        }
        return this.substringMultiSegs(beginIndex, endIndex);
    }

    private BinaryString substringMultiSegs(int start, int until) {
        int c;
        int charSize;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        for (c = 0; i < this.sizeInBytes && c < start; i += charSize, ++c) {
            charSize = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charSize, segSize);
        }
        int j = i;
        while (i < this.sizeInBytes && c < until) {
            int charSize2 = BinaryString.numBytesForFirstByte(index.value());
            i += charSize2;
            index.skipBytes(charSize2, segSize);
            ++c;
        }
        if (i > j) {
            return BinaryString.fromBytes(MemorySegmentUtils.copyToBytes(this.segments, this.offset + j, i - j));
        }
        return EMPTY_UTF8;
    }

    public boolean contains(BinaryString s) {
        if (s.sizeInBytes == 0) {
            return true;
        }
        int find = MemorySegmentUtils.find(this.segments, this.offset, this.sizeInBytes, s.segments, s.offset, s.sizeInBytes);
        return find != -1;
    }

    public boolean startsWith(BinaryString prefix) {
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(BinaryString suffix) {
        return this.matchAt(suffix, this.sizeInBytes - suffix.sizeInBytes);
    }

    public BinaryString trim() {
        if (this.inFirstSegment()) {
            int s;
            int e = this.sizeInBytes - 1;
            for (s = 0; s < this.sizeInBytes && this.getByteOneSegment(s) == 32; ++s) {
            }
            while (e >= s && this.getByteOneSegment(e) == 32) {
                --e;
            }
            if (s > e) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s, e - s + 1);
        }
        return this.trimMultiSegs();
    }

    private BinaryString trimMultiSegs() {
        int s;
        int e = this.sizeInBytes - 1;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s = 0; s < this.sizeInBytes && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        while (e >= s && behind.value() == 32) {
            --e;
            behind.previousByte(segSize);
        }
        if (s > e) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s, e);
    }

    public int indexOf(BinaryString str, int fromIndex) {
        if (str.sizeInBytes == 0) {
            return 0;
        }
        if (this.inFirstSegment()) {
            int charIdx;
            int byteIdx = 0;
            for (charIdx = 0; byteIdx < this.sizeInBytes && charIdx < fromIndex; byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSegment(byteIdx)), ++charIdx) {
            }
            do {
                if (byteIdx + str.sizeInBytes > this.sizeInBytes) {
                    return -1;
                }
                if (MemorySegmentUtils.equals(this.segments, this.offset + byteIdx, str.segments, str.offset, str.sizeInBytes)) {
                    return charIdx;
                }
                byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSegment(byteIdx));
                ++charIdx;
            } while (byteIdx < this.sizeInBytes);
            return -1;
        }
        return this.indexOfMultiSegs(str, fromIndex);
    }

    private int indexOfMultiSegs(BinaryString str, int fromIndex) {
        int charIdx;
        int charBytes;
        int byteIdx = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (charIdx = 0; byteIdx < this.sizeInBytes && charIdx < fromIndex; byteIdx += charBytes, ++charIdx) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charBytes, segSize);
        }
        do {
            if (byteIdx + str.sizeInBytes > this.sizeInBytes) {
                return -1;
            }
            if (MemorySegmentUtils.equals(this.segments, this.offset + byteIdx, str.segments, str.offset, str.sizeInBytes)) {
                return charIdx;
            }
            charBytes = BinaryString.numBytesForFirstByte(index.segment.get(index.offset));
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        } while ((byteIdx += charBytes) < this.sizeInBytes);
        return -1;
    }

    public BinaryString toUpperCase() {
        if (this.sizeInBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.sizeInBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.sizeInBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.javaToUpperCase();
            }
            int upper = Character.toUpperCase(b);
            if (upper > 127) {
                return this.javaToUpperCase();
            }
            bytes[i] = (byte)upper;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString javaToUpperCase() {
        return BinaryString.fromString(this.toString().toUpperCase());
    }

    public BinaryString toLowerCase() {
        if (this.sizeInBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.sizeInBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.sizeInBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.javaToLowerCase();
            }
            int lower = Character.toLowerCase(b);
            if (lower > 127) {
                return this.javaToLowerCase();
            }
            bytes[i] = (byte)lower;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString javaToLowerCase() {
        return BinaryString.fromString(this.toString().toLowerCase());
    }

    byte getByteOneSegment(int i) {
        return this.segments[0].get(this.offset + i);
    }

    boolean inFirstSegment() {
        return this.sizeInBytes + this.offset <= this.segments[0].size();
    }

    private boolean matchAt(BinaryString s, int pos) {
        return this.inFirstSegment() && s.inFirstSegment() ? this.matchAtOneSeg(s, pos) : this.matchAtVarSeg(s, pos);
    }

    private boolean matchAtOneSeg(BinaryString s, int pos) {
        return s.sizeInBytes + pos <= this.sizeInBytes && pos >= 0 && this.segments[0].equalTo(s.segments[0], this.offset + pos, s.offset, s.sizeInBytes);
    }

    private boolean matchAtVarSeg(BinaryString s, int pos) {
        return s.sizeInBytes + pos <= this.sizeInBytes && pos >= 0 && MemorySegmentUtils.equals(this.segments, this.offset + pos, s.segments, s.offset, s.sizeInBytes);
    }

    BinaryString copyBinaryStringInOneSeg(int start, int len) {
        byte[] newBytes = new byte[len];
        this.segments[0].get(this.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    BinaryString copyBinaryString(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        MemorySegmentUtils.copyToBytes(this.segments, this.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    SegmentAndOffset firstSegmentAndOffset(int segSize) {
        int segIndex = this.offset / segSize;
        return new SegmentAndOffset(segIndex, this.offset % segSize);
    }

    SegmentAndOffset lastSegmentAndOffset(int segSize) {
        int lastOffset = this.offset + this.sizeInBytes - 1;
        int segIndex = lastOffset / segSize;
        return new SegmentAndOffset(segIndex, lastOffset % segSize);
    }

    private SegmentAndOffset startSegmentAndOffset(int segSize) {
        return this.inFirstSegment() ? new SegmentAndOffset(0, this.offset) : this.firstSegmentAndOffset(segSize);
    }

    static int numBytesForFirstByte(byte b) {
        if (b >= 0) {
            return 1;
        }
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return 2;
        }
        if (b >> 4 == -2) {
            return 3;
        }
        if (b >> 3 == -2) {
            return 4;
        }
        return 1;
    }

    public static byte[] encodeUTF8(String str) {
        byte[] bytes = MemorySegmentUtils.allocateReuseBytes(str.length() * 3);
        int len = BinaryString.encodeUTF8(str, bytes);
        return Arrays.copyOf(bytes, len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(String str, byte[] bytes) {
        int offset = 0;
        int len = str.length();
        int sl = offset + len;
        int dp = 0;
        int dlASCII = dp + Math.min(len, bytes.length);
        while (dp < dlASCII && str.charAt(offset) < '\u0080') {
            bytes[dp++] = (byte)str.charAt(offset++);
        }
        while (offset < sl) {
            char c;
            if ((c = str.charAt(offset++)) < '\u0080') {
                bytes[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[dp++] = (byte)(0xC0 | c >> 6);
                bytes[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char c2;
                int ip = offset - 1;
                if (Character.isHighSurrogate(c)) {
                    if (sl - ip < 2) {
                        c2 = '\uffffffff';
                    } else {
                        char d = str.charAt(ip + 1);
                        if (!Character.isLowSurrogate(d)) return BinaryString.defaultEncodeUTF8(str, bytes);
                        c2 = Character.toCodePoint(c, d);
                    }
                } else {
                    if (Character.isLowSurrogate(c)) {
                        return BinaryString.defaultEncodeUTF8(str, bytes);
                    }
                    c2 = c;
                }
                if (c2 < '\u0000') {
                    bytes[dp++] = 63;
                    continue;
                }
                bytes[dp++] = (byte)(0xF0 | c2 >> 18);
                bytes[dp++] = (byte)(0x80 | c2 >> 12 & 0x3F);
                bytes[dp++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytes[dp++] = (byte)(0x80 | c2 & 0x3F);
                ++offset;
                continue;
            }
            bytes[dp++] = (byte)(0xE0 | c >> 12);
            bytes[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[dp++] = (byte)(0x80 | c & 0x3F);
        }
        return dp;
    }

    public static int defaultEncodeUTF8(String str, byte[] bytes) {
        try {
            byte[] buffer = str.getBytes("UTF-8");
            System.arraycopy(buffer, 0, bytes, 0, buffer.length);
            return buffer.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encodeUTF8 error", e);
        }
    }

    public static String decodeUTF8(byte[] input, int offset, int byteLen) {
        char[] chars = MemorySegmentUtils.allocateReuseChars(byteLen);
        int len = BinaryString.decodeUTF8Strict(input, offset, byteLen, chars);
        if (len < 0) {
            return BinaryString.defaultDecodeUTF8(input, offset, byteLen);
        }
        return new String(chars, 0, len);
    }

    public static int decodeUTF8Strict(byte[] sa, int sp, int len, char[] da) {
        int sl = sp + len;
        int dp = 0;
        int dlASCII = Math.min(len, da.length);
        while (dp < dlASCII && sa[sp] >= 0) {
            da[dp++] = (char)sa[sp++];
        }
        while (sp < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = sa[sp++]) >= 0) {
                da[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (sp < sl) {
                    if (((b2 = sa[sp++]) & 0xC0) != 128) {
                        return -1;
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (sp + 1 < sl) {
                    b2 = sa[sp++];
                    b3 = sa[sp++];
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return -1;
                    }
                    da[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (sp + 2 < sl) {
                    b2 = sa[sp++];
                    b3 = sa[sp++];
                    byte b4 = sa[sp++];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(uc)) {
                        return -1;
                    }
                    da[dp++] = Character.highSurrogate(uc);
                    da[dp++] = Character.lowSurrogate(uc);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static String decodeUTF8(MemorySegment input, int offset, int byteLen) {
        char[] chars = MemorySegmentUtils.allocateReuseChars(byteLen);
        int len = BinaryString.decodeUTF8Strict(input, offset, byteLen, chars);
        if (len < 0) {
            byte[] bytes = MemorySegmentUtils.allocateReuseBytes(byteLen);
            input.get(offset, bytes, 0, byteLen);
            return BinaryString.defaultDecodeUTF8(bytes, 0, byteLen);
        }
        return new String(chars, 0, len);
    }

    public static int decodeUTF8Strict(MemorySegment segment, int sp, int len, char[] da) {
        int sl = sp + len;
        int dp = 0;
        int dlASCII = Math.min(len, da.length);
        while (dp < dlASCII && segment.get(sp) >= 0) {
            da[dp++] = (char)segment.get(sp++);
        }
        while (sp < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = segment.get(sp++)) >= 0) {
                da[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (sp < sl) {
                    if (((b2 = segment.get(sp++)) & 0xC0) != 128) {
                        return -1;
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (sp + 1 < sl) {
                    b2 = segment.get(sp++);
                    b3 = segment.get(sp++);
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return -1;
                    }
                    da[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (sp + 2 < sl) {
                    b2 = segment.get(sp++);
                    b3 = segment.get(sp++);
                    byte b4 = segment.get(sp++);
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(uc)) {
                        return -1;
                    }
                    da[dp++] = Character.highSurrogate(uc);
                    da[dp++] = Character.lowSurrogate(uc);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static String defaultDecodeUTF8(byte[] bytes, int offset, int len) {
        return new String(bytes, offset, len, StandardCharsets.UTF_8);
    }

    class SegmentAndOffset {
        int segIndex;
        MemorySegment segment;
        int offset;

        private SegmentAndOffset(int segIndex, int offset) {
            this.segIndex = segIndex;
            this.segment = BinaryString.this.segments[segIndex];
            this.offset = offset;
        }

        private void assignSegment() {
            this.segment = this.segIndex >= 0 && this.segIndex < BinaryString.this.segments.length ? BinaryString.this.segments[this.segIndex] : null;
        }

        void previousByte(int segSize) {
            --this.offset;
            if (this.offset == -1) {
                --this.segIndex;
                this.assignSegment();
                this.offset = segSize - 1;
            }
        }

        void nextByte(int segSize) {
            ++this.offset;
            this.checkAdvance(segSize);
        }

        private void checkAdvance(int segSize) {
            if (this.offset == segSize) {
                this.advance();
            }
        }

        private void advance() {
            ++this.segIndex;
            this.assignSegment();
            this.offset = 0;
        }

        void skipBytes(int n, int segSize) {
            int remaining = segSize - this.offset;
            if (remaining > n) {
                this.offset += n;
            } else {
                while (true) {
                    int toSkip;
                    if ((n -= (toSkip = Math.min(remaining, n))) <= 0) {
                        this.offset += toSkip;
                        this.checkAdvance(segSize);
                        return;
                    }
                    this.advance();
                    remaining = segSize - this.offset;
                }
            }
        }

        byte value() {
            return this.segment.get(this.offset);
        }
    }
}

