/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryArrayWriter;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.DataType;

public class InternalArraySerializer
implements Serializer<InternalArray> {
    private static final long serialVersionUID = 1L;
    private final DataType eleType;
    private final Serializer<Object> eleSer;
    private final InternalArray.ElementGetter elementGetter;
    private transient BinaryArray reuseArray;
    private transient BinaryArrayWriter reuseWriter;

    public InternalArraySerializer(DataType eleType) {
        this(eleType, InternalSerializers.create(eleType));
    }

    private InternalArraySerializer(DataType eleType, Serializer<Object> eleSer) {
        this.eleType = eleType;
        this.eleSer = eleSer;
        this.elementGetter = InternalArray.createElementGetter(eleType);
    }

    public InternalArraySerializer duplicate() {
        return new InternalArraySerializer(this.eleType, this.eleSer.duplicate());
    }

    @Override
    public InternalArray copy(InternalArray from) {
        if (from instanceof GenericArray) {
            return this.copyGenericArray((GenericArray)from);
        }
        if (from instanceof BinaryArray) {
            return ((BinaryArray)from).copy();
        }
        return this.toBinaryArray(from).copy();
    }

    private GenericArray copyGenericArray(GenericArray array) {
        if (array.isPrimitiveArray()) {
            switch (this.eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return new GenericArray(Arrays.copyOf(array.toBooleanArray(), array.size()));
                }
                case TINYINT: {
                    return new GenericArray(Arrays.copyOf(array.toByteArray(), array.size()));
                }
                case SMALLINT: {
                    return new GenericArray(Arrays.copyOf(array.toShortArray(), array.size()));
                }
                case INTEGER: {
                    return new GenericArray(Arrays.copyOf(array.toIntArray(), array.size()));
                }
                case BIGINT: {
                    return new GenericArray(Arrays.copyOf(array.toLongArray(), array.size()));
                }
                case FLOAT: {
                    return new GenericArray(Arrays.copyOf(array.toFloatArray(), array.size()));
                }
                case DOUBLE: {
                    return new GenericArray(Arrays.copyOf(array.toDoubleArray(), array.size()));
                }
            }
            throw new RuntimeException("Unknown type: " + this.eleType);
        }
        Object[] objectArray = array.toObjectArray();
        Object[] newArray = (Object[])Array.newInstance(InternalRow.getDataClass(this.eleType), array.size());
        for (int i = 0; i < array.size(); ++i) {
            if (objectArray[i] == null) continue;
            newArray[i] = this.eleSer.copy(objectArray[i]);
        }
        return new GenericArray(newArray);
    }

    @Override
    public void serialize(InternalArray record, DataOutputView target) throws IOException {
        BinaryArray binaryArray = this.toBinaryArray(record);
        target.writeInt(binaryArray.getSizeInBytes());
        MemorySegmentUtils.copyToView(binaryArray.getSegments(), binaryArray.getOffset(), binaryArray.getSizeInBytes(), target);
    }

    public BinaryArray toBinaryArray(InternalArray from) {
        if (from instanceof BinaryArray) {
            return (BinaryArray)from;
        }
        int numElements = from.size();
        if (this.reuseArray == null) {
            this.reuseArray = new BinaryArray();
        }
        if (this.reuseWriter == null || this.reuseWriter.getNumElements() != numElements) {
            this.reuseWriter = new BinaryArrayWriter(this.reuseArray, numElements, BinaryArray.calculateFixLengthPartSize(this.eleType));
        } else {
            this.reuseWriter.reset();
        }
        for (int i = 0; i < numElements; ++i) {
            if (from.isNullAt(i)) {
                this.reuseWriter.setNullAt(i, this.eleType);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, this.elementGetter.getElementOrNull(from, i), this.eleType, this.eleSer);
        }
        this.reuseWriter.complete();
        return this.reuseArray;
    }

    @Override
    public InternalArray deserialize(DataInputView source) throws IOException {
        return this.deserializeReuse(new BinaryArray(), source);
    }

    private BinaryArray deserializeReuse(BinaryArray reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, bytes.length);
        return reuse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalArraySerializer that = (InternalArraySerializer)o;
        return this.eleType.equals(that.eleType);
    }

    public int hashCode() {
        return this.eleType.hashCode();
    }
}

