/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.security;

import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.options.Options;
import org.apache.paimon.security.HadoopModule;
import org.apache.paimon.security.HadoopSecurityContext;
import org.apache.paimon.security.SecurityConfiguration;
import org.apache.paimon.utils.HadoopUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class SecurityContext {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityContext.class);
    private static HadoopSecurityContext installedContext;

    public static void install(Options options) throws Exception {
        SecurityContext.install(options, HadoopUtils.getHadoopConfiguration(options));
    }

    public static void install(CatalogContext catalogContext) throws Exception {
        SecurityContext.install(catalogContext.options(), catalogContext.hadoopConf());
    }

    private static void install(Options options, Configuration configuration) throws Exception {
        SecurityConfiguration config = new SecurityConfiguration(options);
        if (config.isLegal()) {
            HadoopModule module = new HadoopModule(config, configuration);
            module.install();
            installedContext = new HadoopSecurityContext();
        }
    }

    public static <T> T runSecured(Callable<T> securedCallable) throws Exception {
        return installedContext != null ? installedContext.runSecured(securedCallable) : securedCallable.call();
    }
}

