/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.parquet.reader.ParquetDataColumnReader;
import org.apache.paimon.format.parquet.reader.TimestampColumnReader;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.column.Dictionary;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.utils.Preconditions;

public final class ParquetDataColumnReaderFactory {
    private ParquetDataColumnReaderFactory() {
    }

    private static ParquetDataColumnReader getDataColumnReaderByTypeHelper(boolean isDictionary, PrimitiveType parquetType, @Nullable Dictionary dictionary, @Nullable ValuesReader valuesReader, boolean isUtcTimestamp) {
        if (parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return isDictionary ? new TypesFromInt96PageReader(dictionary, isUtcTimestamp) : new TypesFromInt96PageReader(valuesReader, isUtcTimestamp);
        }
        return isDictionary ? new DefaultParquetDataColumnReader(dictionary) : new DefaultParquetDataColumnReader(valuesReader);
    }

    public static ParquetDataColumnReader getDataColumnReaderByTypeOnDictionary(PrimitiveType parquetType, Dictionary realReader, boolean isUtcTimestamp) {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(true, parquetType, realReader, null, isUtcTimestamp);
    }

    public static ParquetDataColumnReader getDataColumnReaderByType(PrimitiveType parquetType, ValuesReader realReader, boolean isUtcTimestamp) {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(false, parquetType, null, realReader, isUtcTimestamp);
    }

    public static class TypesFromInt96PageReader
    extends DefaultParquetDataColumnReader {
        private final boolean isUtcTimestamp;

        public TypesFromInt96PageReader(ValuesReader realReader, boolean isUtcTimestamp) {
            super(realReader);
            this.isUtcTimestamp = isUtcTimestamp;
        }

        public TypesFromInt96PageReader(Dictionary dict, boolean isUtcTimestamp) {
            super(dict);
            this.isUtcTimestamp = isUtcTimestamp;
        }

        private Timestamp convert(Binary binary) {
            ByteBuffer buf = binary.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = buf.getLong();
            int julianDay = buf.getInt();
            return TimestampColumnReader.int96ToTimestamp(this.isUtcTimestamp, timeOfDayNanos, julianDay);
        }

        @Override
        public Timestamp readTimestamp(int id) {
            return this.convert(this.dict.decodeToBinary(id));
        }

        @Override
        public Timestamp readMillsTimestamp() {
            return this.convert(this.valuesReader.readBytes());
        }

        @Override
        public Timestamp readMicrosTimestamp() {
            return this.convert(this.valuesReader.readBytes());
        }
    }

    public static class DefaultParquetDataColumnReader
    implements ParquetDataColumnReader {
        protected final ValuesReader valuesReader;
        protected final Dictionary dict;

        public DefaultParquetDataColumnReader(ValuesReader valuesReader) {
            this.valuesReader = (ValuesReader)Preconditions.checkNotNull((Object)valuesReader);
            this.dict = null;
        }

        public DefaultParquetDataColumnReader(Dictionary dict) {
            this.valuesReader = null;
            this.dict = (Dictionary)Preconditions.checkNotNull((Object)dict);
        }

        @Override
        public void initFromPage(int i, ByteBufferInputStream in) throws IOException {
            this.valuesReader.initFromPage(i, in);
        }

        @Override
        public boolean readBoolean() {
            return this.valuesReader.readBoolean();
        }

        @Override
        public boolean readBoolean(int id) {
            return this.dict.decodeToBoolean(id);
        }

        @Override
        public byte[] readBytes() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readBytes(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readFloat();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readDouble();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToDouble(id);
        }

        @Override
        public Timestamp readMillsTimestamp() {
            return Timestamp.fromEpochMillis((long)this.valuesReader.readLong());
        }

        @Override
        public Timestamp readMicrosTimestamp() {
            return Timestamp.fromMicros((long)this.valuesReader.readLong());
        }

        @Override
        public Timestamp readTimestamp(int id) {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public int readInteger() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readInteger(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readLong();
        }

        @Override
        public int readSmallInt() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readSmallInt(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public int readTinyInt() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readTinyInt(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public int readValueDictionaryId() {
            return this.valuesReader.readValueDictionaryId();
        }

        public void skip() {
            this.valuesReader.skip();
        }

        @Override
        public Dictionary getDictionary() {
            return this.dict;
        }
    }
}

