/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.List;
import java.util.Random;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.paimon.shade.org.apache.orc.EncryptionAlgorithm;
import org.apache.paimon.shade.org.apache.orc.impl.HadoopShims;
import org.apache.paimon.shade.org.apache.orc.impl.HadoopShimsCurrent;
import org.apache.paimon.shade.org.apache.orc.impl.KeyProvider;
import org.apache.paimon.shade.org.apache.orc.impl.LocalKey;

class KeyProviderImpl
implements KeyProvider {
    private final org.apache.hadoop.crypto.key.KeyProvider provider;
    private final Random random;

    KeyProviderImpl(org.apache.hadoop.crypto.key.KeyProvider provider, Random random) {
        this.provider = provider;
        this.random = random;
    }

    @Override
    public List<String> getKeyNames() throws IOException {
        return this.provider.getKeys();
    }

    @Override
    public HadoopShims.KeyMetadata getCurrentKeyVersion(String keyName) throws IOException {
        KeyProvider.Metadata meta = this.provider.getMetadata(keyName);
        return new HadoopShims.KeyMetadata(keyName, meta.getVersions() - 1, HadoopShimsCurrent.findAlgorithm(meta));
    }

    private static void unmangleIv(byte[] input, byte[] output) {
        for (int i = 0; i < output.length && i < input.length; ++i) {
            output[i] = (byte)(0xFF ^ input[i]);
        }
    }

    @Override
    public LocalKey createLocalKey(HadoopShims.KeyMetadata key) throws IOException {
        EncryptionAlgorithm algorithm = key.getAlgorithm();
        byte[] encryptedKey = new byte[algorithm.keyLength()];
        this.random.nextBytes(encryptedKey);
        byte[] iv = new byte[algorithm.getIvLength()];
        KeyProviderImpl.unmangleIv(encryptedKey, iv);
        KeyProviderCryptoExtension.EncryptedKeyVersion param = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)key.getKeyName(), (String)HadoopShimsCurrent.buildKeyVersionName(key), (byte[])iv, (byte[])encryptedKey);
        try {
            KeyProvider.KeyVersion decryptedKey;
            if (this.provider instanceof KeyProviderCryptoExtension) {
                decryptedKey = ((KeyProviderCryptoExtension)this.provider).decryptEncryptedKey(param);
            } else if (this.provider instanceof KeyProviderCryptoExtension.CryptoExtension) {
                decryptedKey = ((KeyProviderCryptoExtension.CryptoExtension)this.provider).decryptEncryptedKey(param);
            } else {
                throw new UnsupportedOperationException(this.provider.getClass().getCanonicalName() + " is not supported.");
            }
            return new LocalKey(algorithm, decryptedKey.getMaterial(), encryptedKey);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Can't create local encryption key for " + key, e);
        }
    }

    @Override
    public Key decryptLocalKey(HadoopShims.KeyMetadata key, byte[] encryptedKey) throws IOException {
        EncryptionAlgorithm algorithm = key.getAlgorithm();
        byte[] iv = new byte[algorithm.getIvLength()];
        KeyProviderImpl.unmangleIv(encryptedKey, iv);
        KeyProviderCryptoExtension.EncryptedKeyVersion param = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)key.getKeyName(), (String)HadoopShimsCurrent.buildKeyVersionName(key), (byte[])iv, (byte[])encryptedKey);
        try {
            KeyProvider.KeyVersion decryptedKey;
            if (this.provider instanceof KeyProviderCryptoExtension) {
                decryptedKey = ((KeyProviderCryptoExtension)this.provider).decryptEncryptedKey(param);
            } else if (this.provider instanceof KeyProviderCryptoExtension.CryptoExtension) {
                decryptedKey = ((KeyProviderCryptoExtension.CryptoExtension)this.provider).decryptEncryptedKey(param);
            } else {
                throw new UnsupportedOperationException(this.provider.getClass().getCanonicalName() + " is not supported.");
            }
            return new SecretKeySpec(decryptedKey.getMaterial(), algorithm.getAlgorithm());
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    @Override
    public HadoopShims.KeyProviderKind getKind() {
        return HadoopShims.KeyProviderKind.HADOOP;
    }
}

